% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_update_firewall_analysis_settings}
\alias{networkfirewall_update_firewall_analysis_settings}
\title{Enables specific types of firewall analysis on a specific firewall you
define}
\usage{
networkfirewall_update_firewall_analysis_settings(
  EnabledAnalysisTypes = NULL,
  FirewallArn = NULL,
  FirewallName = NULL,
  UpdateToken = NULL
)
}
\arguments{
\item{EnabledAnalysisTypes}{An optional setting indicating the specific traffic analysis types to
enable on the firewall.}

\item{FirewallArn}{The Amazon Resource Name (ARN) of the firewall.

You must specify the ARN or the name, and you can specify both.}

\item{FirewallName}{The descriptive name of the firewall. You can't change the name of a
firewall after you create it.

You must specify the ARN or the name, and you can specify both.}

\item{UpdateToken}{An optional token that you can use for optimistic locking. Network
Firewall returns a token to your requests that access the firewall. The
token marks the state of the firewall resource at the time of the
request.

To make an unconditional change to the firewall, omit the token in your
update request. Without the token, Network Firewall performs your
updates regardless of whether the firewall has changed since you last
retrieved it.

To make a conditional change to the firewall, provide the token in your
update request. Network Firewall uses the token to ensure that the
firewall hasn't changed since you last retrieved it. If it has changed,
the operation fails with an \code{InvalidTokenException}. If this happens,
retrieve the firewall again to get a current copy of it with a new
token. Reapply your changes as needed, then try the operation again
using the new token.}
}
\description{
Enables specific types of firewall analysis on a specific firewall you define.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_analysis_settings/} for full documentation.
}
\keyword{internal}
