% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_get_network_telemetry}
\alias{networkmanager_get_network_telemetry}
\title{Gets the network telemetry of the specified global network}
\usage{
networkmanager_get_network_telemetry(
  GlobalNetworkId,
  CoreNetworkId = NULL,
  RegisteredGatewayArn = NULL,
  AwsRegion = NULL,
  AccountId = NULL,
  ResourceType = NULL,
  ResourceArn = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{CoreNetworkId}{The ID of a core network.}

\item{RegisteredGatewayArn}{The ARN of the gateway.}

\item{AwsRegion}{The Amazon Web Services Region.}

\item{AccountId}{The Amazon Web Services account ID.}

\item{ResourceType}{The resource type. The following are the supported resource types:
\itemize{
\item \code{connect-peer}
\item \code{transit-gateway-connect-peer}
\item \code{vpn-connection}
}}

\item{ResourceArn}{The ARN of the resource.}

\item{MaxResults}{The maximum number of results to return.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Gets the network telemetry of the specified global network.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_get_network_telemetry/} for full documentation.
}
\keyword{internal}
