% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_operations.R
\name{account_list_regions}
\alias{account_list_regions}
\title{Lists all the Regions for a given account and their respective opt-in
statuses}
\usage{
account_list_regions(
  AccountId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  RegionOptStatusContains = NULL
)
}
\arguments{
\item{AccountId}{Specifies the 12-digit account ID number of the Amazon Web Services
account that you want to access or modify with this operation. If you
don't specify this parameter, it defaults to the Amazon Web Services
account of the identity used to call the operation. To use this
parameter, the caller must be an identity in the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account}{organization's management account}
or a delegated administrator account. The specified account ID must be a
member account in the same organization. The organization must have \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html}{all features enabled},
and the organization must have \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{trusted access}
enabled for the Account Management service, and optionally a \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{delegated admin}
account assigned.

The management account can't specify its own \code{AccountId}. It must call
the operation in standalone context by not including the \code{AccountId}
parameter.

To call this operation on an account that is not a member of an
organization, don't specify this parameter. Instead, call the operation
using an identity belonging to the account whose contacts you wish to
retrieve or modify.}

\item{MaxResults}{The total number of items to return in the command’s output. If the
total number of items available is more than the value specified, a
\code{NextToken} is provided in the command’s output. To resume pagination,
provide the \code{NextToken} value in the \code{starting-token} argument of a
subsequent command. Do not use the \code{NextToken} response element directly
outside of the Amazon Web Services CLI. For usage examples, see
\href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html}{Pagination}
in the \emph{Amazon Web Services Command Line Interface User Guide}.}

\item{NextToken}{A token used to specify where to start paginating. This is the
\code{NextToken} from a previously truncated response. For usage examples,
see
\href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html}{Pagination}
in the \emph{Amazon Web Services Command Line Interface User Guide}.}

\item{RegionOptStatusContains}{A list of Region statuses (Enabling, Enabled, Disabling, Disabled,
Enabled_by_default) to use to filter the list of Regions for a given
account. For example, passing in a value of ENABLING will only return a
list of Regions with a Region status of ENABLING.}
}
\description{
Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be filtered by the \code{region-opt-status-contains} parameter.

See \url{https://www.paws-r-sdk.com/docs/account_list_regions/} for full documentation.
}
\keyword{internal}
