# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include glacier_service.R
NULL

#' This operation aborts a multipart upload identified by the upload ID
#'
#' @description
#' This operation aborts a multipart upload identified by the upload ID.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_abort_multipart_upload/](https://www.paws-r-sdk.com/docs/glacier_abort_multipart_upload/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload to delete.
#'
#' @keywords internal
#'
#' @rdname glacier_abort_multipart_upload
glacier_abort_multipart_upload <- function(accountId, vaultName, uploadId) {
  op <- new_operation(
    name = "AbortMultipartUpload",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$abort_multipart_upload_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId)
  output <- .glacier$abort_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$abort_multipart_upload <- glacier_abort_multipart_upload

#' This operation aborts the vault locking process if the vault lock is not
#' in the Locked state
#'
#' @description
#' This operation aborts the vault locking process if the vault lock is not in the `Locked` state. If the vault lock is in the `Locked` state when this operation is requested, the operation returns an `AccessDeniedException` error. Aborting the vault locking process removes the vault lock policy from the specified vault.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_abort_vault_lock/](https://www.paws-r-sdk.com/docs/glacier_abort_vault_lock/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_abort_vault_lock
glacier_abort_vault_lock <- function(accountId, vaultName) {
  op <- new_operation(
    name = "AbortVaultLock",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$abort_vault_lock_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$abort_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$abort_vault_lock <- glacier_abort_vault_lock

#' This operation adds the specified tags to a vault
#'
#' @description
#' This operation adds the specified tags to a vault. Each tag is composed of a key and a value. Each vault can have up to 10 tags. If your request would cause the tag limit for the vault to be exceeded, the operation throws the `LimitExceededException` error. If a tag already exists on the vault under a specified key, the existing key value will be overwritten. For more information about tags, see [Tagging Amazon S3 Glacier Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_add_tags_to_vault/](https://www.paws-r-sdk.com/docs/glacier_add_tags_to_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param Tags The tags to add to the vault. Each tag is composed of a key and a value.
#' The value can be an empty string.
#'
#' @keywords internal
#'
#' @rdname glacier_add_tags_to_vault
glacier_add_tags_to_vault <- function(accountId, vaultName, Tags = NULL) {
  op <- new_operation(
    name = "AddTagsToVault",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/tags?operation=add",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$add_tags_to_vault_input(accountId = accountId, vaultName = vaultName, Tags = Tags)
  output <- .glacier$add_tags_to_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$add_tags_to_vault <- glacier_add_tags_to_vault

#' You call this operation to inform Amazon S3 Glacier (Glacier) that all
#' the archive parts have been uploaded and that Glacier can now assemble
#' the archive from the uploaded parts
#'
#' @description
#' You call this operation to inform Amazon S3 Glacier (Glacier) that all the archive parts have been uploaded and that Glacier can now assemble the archive from the uploaded parts. After assembling and saving the archive to the vault, Glacier returns the URI path of the newly created archive resource. Using the URI path, you can then access the archive. After you upload an archive, you should save the archive ID returned to retrieve the archive at a later point. You can also get the vault inventory to obtain a list of archive IDs in a vault. For more information, see [`initiate_job`][glacier_initiate_job].
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_complete_multipart_upload/](https://www.paws-r-sdk.com/docs/glacier_complete_multipart_upload/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param archiveSize The total size, in bytes, of the entire archive. This value should be
#' the sum of all the sizes of the individual parts that you uploaded.
#' @param checksum The SHA256 tree hash of the entire archive. It is the tree hash of
#' SHA256 tree hash of the individual parts. If the value you specify in
#' the request does not match the SHA256 tree hash of the final assembled
#' archive as computed by Amazon S3 Glacier (Glacier), Glacier returns an
#' error and the request fails.
#'
#' @keywords internal
#'
#' @rdname glacier_complete_multipart_upload
glacier_complete_multipart_upload <- function(accountId, vaultName, uploadId, archiveSize = NULL, checksum = NULL) {
  op <- new_operation(
    name = "CompleteMultipartUpload",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$complete_multipart_upload_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, archiveSize = archiveSize, checksum = checksum)
  output <- .glacier$complete_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$complete_multipart_upload <- glacier_complete_multipart_upload

#' This operation completes the vault locking process by transitioning the
#' vault lock from the InProgress state to the Locked state, which causes
#' the vault lock policy to become unchangeable
#'
#' @description
#' This operation completes the vault locking process by transitioning the vault lock from the `InProgress` state to the `Locked` state, which causes the vault lock policy to become unchangeable. A vault lock is put into the `InProgress` state by calling [`initiate_vault_lock`][glacier_initiate_vault_lock]. You can obtain the state of the vault lock by calling [`get_vault_lock`][glacier_get_vault_lock]. For more information about the vault locking process, [Amazon Glacier Vault Lock](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_complete_vault_lock/](https://www.paws-r-sdk.com/docs/glacier_complete_vault_lock/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param lockId &#91;required&#93; The `lockId` value is the lock ID obtained from a
#' [`initiate_vault_lock`][glacier_initiate_vault_lock] request.
#'
#' @keywords internal
#'
#' @rdname glacier_complete_vault_lock
glacier_complete_vault_lock <- function(accountId, vaultName, lockId) {
  op <- new_operation(
    name = "CompleteVaultLock",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$complete_vault_lock_input(accountId = accountId, vaultName = vaultName, lockId = lockId)
  output <- .glacier$complete_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$complete_vault_lock <- glacier_complete_vault_lock

#' This operation creates a new vault with the specified name
#'
#' @description
#' This operation creates a new vault with the specified name. The name of the vault must be unique within a region for an AWS account. You can create up to 1,000 vaults per account. If you need to create more vaults, contact Amazon S3 Glacier.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_create_vault/](https://www.paws-r-sdk.com/docs/glacier_create_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_create_vault
glacier_create_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "CreateVault",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$create_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$create_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$create_vault <- glacier_create_vault

#' This operation deletes an archive from a vault
#'
#' @description
#' This operation deletes an archive from a vault. Subsequent requests to initiate a retrieval of this archive will fail. Archive retrievals that are in progress for this archive ID may or may not succeed according to the following scenarios:
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_delete_archive/](https://www.paws-r-sdk.com/docs/glacier_delete_archive/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param archiveId &#91;required&#93; The ID of the archive to delete.
#'
#' @keywords internal
#'
#' @rdname glacier_delete_archive
glacier_delete_archive <- function(accountId, vaultName, archiveId) {
  op <- new_operation(
    name = "DeleteArchive",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$delete_archive_input(accountId = accountId, vaultName = vaultName, archiveId = archiveId)
  output <- .glacier$delete_archive_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_archive <- glacier_delete_archive

#' This operation deletes a vault
#'
#' @description
#' This operation deletes a vault. Amazon S3 Glacier will delete a vault only if there are no archives in the vault as of the last inventory and there have been no writes to the vault since the last inventory. If either of these conditions is not satisfied, the vault deletion fails (that is, the vault is not removed) and Amazon S3 Glacier returns an error. You can use [`describe_vault`][glacier_describe_vault] to return the number of archives in a vault, and you can use [Initiate a Job (POST jobs)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html) to initiate a new inventory retrieval for a vault. The inventory contains the archive IDs you use to delete archives using [Delete Archive (DELETE archive)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_delete_vault/](https://www.paws-r-sdk.com/docs/glacier_delete_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault
glacier_delete_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVault",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$delete_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault <- glacier_delete_vault

#' This operation deletes the access policy associated with the specified
#' vault
#'
#' @description
#' This operation deletes the access policy associated with the specified vault. The operation is eventually consistent; that is, it might take some time for Amazon S3 Glacier to completely remove the access policy, and you might still see the effect of the policy for a short time after you send the delete request.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_delete_vault_access_policy/](https://www.paws-r-sdk.com/docs/glacier_delete_vault_access_policy/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault_access_policy
glacier_delete_vault_access_policy <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVaultAccessPolicy",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$delete_vault_access_policy_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault_access_policy <- glacier_delete_vault_access_policy

#' This operation deletes the notification configuration set for a vault
#'
#' @description
#' This operation deletes the notification configuration set for a vault. The operation is eventually consistent; that is, it might take some time for Amazon S3 Glacier to completely disable the notifications and you might still receive some notifications for a short time after you send the delete request.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_delete_vault_notifications/](https://www.paws-r-sdk.com/docs/glacier_delete_vault_notifications/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault_notifications
glacier_delete_vault_notifications <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVaultNotifications",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$delete_vault_notifications_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault_notifications <- glacier_delete_vault_notifications

#' This operation returns information about a job you previously initiated,
#' including the job initiation date, the user who initiated the job, the
#' job status code/message and the Amazon SNS topic to notify after Amazon
#' S3 Glacier (Glacier) completes the job
#'
#' @description
#' This operation returns information about a job you previously initiated, including the job initiation date, the user who initiated the job, the job status code/message and the Amazon SNS topic to notify after Amazon S3 Glacier (Glacier) completes the job. For more information about initiating a job, see [`initiate_job`][glacier_initiate_job].
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_describe_job/](https://www.paws-r-sdk.com/docs/glacier_describe_job/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobId &#91;required&#93; The ID of the job to describe.
#'
#' @keywords internal
#'
#' @rdname glacier_describe_job
glacier_describe_job <- function(accountId, vaultName, jobId) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs/{jobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$describe_job_input(accountId = accountId, vaultName = vaultName, jobId = jobId)
  output <- .glacier$describe_job_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$describe_job <- glacier_describe_job

#' This operation returns information about a vault, including the vault's
#' Amazon Resource Name (ARN), the date the vault was created, the number
#' of archives it contains, and the total size of all the archives in the
#' vault
#'
#' @description
#' This operation returns information about a vault, including the vault's Amazon Resource Name (ARN), the date the vault was created, the number of archives it contains, and the total size of all the archives in the vault. The number of archives and their total size are as of the last inventory generation. This means that if you add or remove an archive from a vault, and then immediately use Describe Vault, the change in contents will not be immediately reflected. If you want to retrieve the latest inventory of the vault, use [`initiate_job`][glacier_initiate_job]. Amazon S3 Glacier generates vault inventories approximately daily. For more information, see [Downloading a Vault Inventory in Amazon S3 Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_describe_vault/](https://www.paws-r-sdk.com/docs/glacier_describe_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_describe_vault
glacier_describe_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DescribeVault",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$describe_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$describe_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$describe_vault <- glacier_describe_vault

#' This operation returns the current data retrieval policy for the account
#' and region specified in the GET request
#'
#' @description
#' This operation returns the current data retrieval policy for the account and region specified in the GET request. For more information about data retrieval policies, see [Amazon Glacier Data Retrieval Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_get_data_retrieval_policy/](https://www.paws-r-sdk.com/docs/glacier_get_data_retrieval_policy/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#'
#' @keywords internal
#'
#' @rdname glacier_get_data_retrieval_policy
glacier_get_data_retrieval_policy <- function(accountId) {
  op <- new_operation(
    name = "GetDataRetrievalPolicy",
    http_method = "GET",
    http_path = "/{accountId}/policies/data-retrieval",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$get_data_retrieval_policy_input(accountId = accountId)
  output <- .glacier$get_data_retrieval_policy_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_data_retrieval_policy <- glacier_get_data_retrieval_policy

#' This operation downloads the output of the job you initiated using
#' InitiateJob
#'
#' @description
#' This operation downloads the output of the job you initiated using [`initiate_job`][glacier_initiate_job]. Depending on the job type you specified when you initiated the job, the output will be either the content of an archive or a vault inventory.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_get_job_output/](https://www.paws-r-sdk.com/docs/glacier_get_job_output/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobId &#91;required&#93; The job ID whose data is downloaded.
#' @param range The range of bytes to retrieve from the output. For example, if you want
#' to download the first 1,048,576 bytes, specify the range as
#' `bytes=0-1048575`. By default, this operation downloads the entire
#' output.
#' 
#' If the job output is large, then you can use a range to retrieve a
#' portion of the output. This allows you to download the entire output in
#' smaller chunks of bytes. For example, suppose you have 1 GB of job
#' output you want to download and you decide to download 128 MB chunks of
#' data at a time, which is a total of eight Get Job Output requests. You
#' use the following process to download the job output:
#' 
#' 1.  Download a 128 MB chunk of output by specifying the appropriate byte
#'     range. Verify that all 128 MB of data was received.
#' 
#' 2.  Along with the data, the response includes a SHA256 tree hash of the
#'     payload. You compute the checksum of the payload on the client and
#'     compare it with the checksum you received in the response to ensure
#'     you received all the expected data.
#' 
#' 3.  Repeat steps 1 and 2 for all the eight 128 MB chunks of output data,
#'     each time specifying the appropriate byte range.
#' 
#' 4.  After downloading all the parts of the job output, you have a list
#'     of eight checksum values. Compute the tree hash of these values to
#'     find the checksum of the entire output. Using the
#'     [`describe_job`][glacier_describe_job] API, obtain job information
#'     of the job that provided you the output. The response includes the
#'     checksum of the entire archive stored in Amazon S3 Glacier. You
#'     compare this value with the checksum you computed to ensure you have
#'     downloaded the entire archive content with no errors.
#'
#' @keywords internal
#'
#' @rdname glacier_get_job_output
glacier_get_job_output <- function(accountId, vaultName, jobId, range = NULL) {
  op <- new_operation(
    name = "GetJobOutput",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$get_job_output_input(accountId = accountId, vaultName = vaultName, jobId = jobId, range = range)
  output <- .glacier$get_job_output_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_job_output <- glacier_get_job_output

#' This operation retrieves the access-policy subresource set on the vault;
#' for more information on setting this subresource, see Set Vault Access
#' Policy (PUT access-policy)
#'
#' @description
#' This operation retrieves the `access-policy` subresource set on the vault; for more information on setting this subresource, see [Set Vault Access Policy (PUT access-policy)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html). If there is no access policy set on the vault, the operation returns a `404 Not found` error. For more information about vault access policies, see [Amazon Glacier Access Control with Vault Access Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_get_vault_access_policy/](https://www.paws-r-sdk.com/docs/glacier_get_vault_access_policy/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_access_policy
glacier_get_vault_access_policy <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultAccessPolicy",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$get_vault_access_policy_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_access_policy <- glacier_get_vault_access_policy

#' This operation retrieves the following attributes from the lock-policy
#' subresource set on the specified vault:
#'
#' @description
#' This operation retrieves the following attributes from the `lock-policy` subresource set on the specified vault:
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_get_vault_lock/](https://www.paws-r-sdk.com/docs/glacier_get_vault_lock/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_lock
glacier_get_vault_lock <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultLock",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$get_vault_lock_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_lock <- glacier_get_vault_lock

#' This operation retrieves the notification-configuration subresource of
#' the specified vault
#'
#' @description
#' This operation retrieves the `notification-configuration` subresource of the specified vault.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_get_vault_notifications/](https://www.paws-r-sdk.com/docs/glacier_get_vault_notifications/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_notifications
glacier_get_vault_notifications <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultNotifications",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$get_vault_notifications_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_notifications <- glacier_get_vault_notifications

#' This operation initiates a job of the specified type, which can be a
#' select, an archival retrieval, or a vault retrieval
#'
#' @description
#' This operation initiates a job of the specified type, which can be a select, an archival retrieval, or a vault retrieval. For more information about using this operation, see the documentation for the underlying REST API [Initiate a Job](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_initiate_job/](https://www.paws-r-sdk.com/docs/glacier_initiate_job/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobParameters Provides options for specifying job information.
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_job
glacier_initiate_job <- function(accountId, vaultName, jobParameters = NULL) {
  op <- new_operation(
    name = "InitiateJob",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$initiate_job_input(accountId = accountId, vaultName = vaultName, jobParameters = jobParameters)
  output <- .glacier$initiate_job_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_job <- glacier_initiate_job

#' This operation initiates a multipart upload
#'
#' @description
#' This operation initiates a multipart upload. Amazon S3 Glacier creates a multipart upload resource and returns its ID in the response. The multipart upload ID is used in subsequent requests to upload parts of an archive (see [`upload_multipart_part`][glacier_upload_multipart_part]).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_initiate_multipart_upload/](https://www.paws-r-sdk.com/docs/glacier_initiate_multipart_upload/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param archiveDescription The archive description that you are uploading in parts.
#' 
#' The part size must be a megabyte (1024 KB) multiplied by a power of 2,
#' for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8
#' MB), and so on. The minimum allowable part size is 1 MB, and the maximum
#' is 4 GB (4096 MB).
#' @param partSize The size of each part except the last, in bytes. The last part can be
#' smaller than this part size.
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_multipart_upload
glacier_initiate_multipart_upload <- function(accountId, vaultName, archiveDescription = NULL, partSize = NULL) {
  op <- new_operation(
    name = "InitiateMultipartUpload",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$initiate_multipart_upload_input(accountId = accountId, vaultName = vaultName, archiveDescription = archiveDescription, partSize = partSize)
  output <- .glacier$initiate_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_multipart_upload <- glacier_initiate_multipart_upload

#' This operation initiates the vault locking process by doing the
#' following:
#'
#' @description
#' This operation initiates the vault locking process by doing the following:
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_initiate_vault_lock/](https://www.paws-r-sdk.com/docs/glacier_initiate_vault_lock/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param policy The vault lock policy as a JSON string, which uses "\\" as an escape
#' character.
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_vault_lock
glacier_initiate_vault_lock <- function(accountId, vaultName, policy = NULL) {
  op <- new_operation(
    name = "InitiateVaultLock",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$initiate_vault_lock_input(accountId = accountId, vaultName = vaultName, policy = policy)
  output <- .glacier$initiate_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_vault_lock <- glacier_initiate_vault_lock

#' This operation lists jobs for a vault, including jobs that are
#' in-progress and jobs that have recently finished
#'
#' @description
#' This operation lists jobs for a vault, including jobs that are in-progress and jobs that have recently finished. The List Job operation returns a list of these jobs sorted by job initiation time.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_jobs/](https://www.paws-r-sdk.com/docs/glacier_list_jobs/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param limit The maximum number of jobs to be returned. The default limit is 50. The
#' number of jobs returned might be fewer than the specified limit, but the
#' number of returned jobs never exceeds the limit.
#' @param marker An opaque string used for pagination. This value specifies the job at
#' which the listing of jobs should begin. Get the marker value from a
#' previous List Jobs response. You only need to include the marker if you
#' are continuing the pagination of results started in a previous List Jobs
#' request.
#' @param statuscode The type of job status to return. You can specify the following values:
#' `InProgress`, `Succeeded`, or `Failed`.
#' @param completed The state of the jobs to return. You can specify `true` or `false`.
#'
#' @keywords internal
#'
#' @rdname glacier_list_jobs
glacier_list_jobs <- function(accountId, vaultName, limit = NULL, marker = NULL, statuscode = NULL, completed = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs",
    host_prefix = "",
    paginator = list(input_token = "marker", output_token = "Marker", limit_key = "limit", result_key = "JobList"),
    stream_api = FALSE
  )
  input <- .glacier$list_jobs_input(accountId = accountId, vaultName = vaultName, limit = limit, marker = marker, statuscode = statuscode, completed = completed)
  output <- .glacier$list_jobs_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_jobs <- glacier_list_jobs

#' This operation lists in-progress multipart uploads for the specified
#' vault
#'
#' @description
#' This operation lists in-progress multipart uploads for the specified vault. An in-progress multipart upload is a multipart upload that has been initiated by an [`initiate_multipart_upload`][glacier_initiate_multipart_upload] request, but has not yet been completed or aborted. The list returned in the List Multipart Upload response has no guaranteed order.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_multipart_uploads/](https://www.paws-r-sdk.com/docs/glacier_list_multipart_uploads/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param marker An opaque string used for pagination. This value specifies the upload at
#' which the listing of uploads should begin. Get the marker value from a
#' previous List Uploads response. You need only include the marker if you
#' are continuing the pagination of results started in a previous List
#' Uploads request.
#' @param limit Specifies the maximum number of uploads returned in the response body.
#' If this value is not specified, the List Uploads operation returns up to
#' 50 uploads.
#'
#' @keywords internal
#'
#' @rdname glacier_list_multipart_uploads
glacier_list_multipart_uploads <- function(accountId, vaultName, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListMultipartUploadsRequest",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads",
    host_prefix = "",
    paginator = list(input_token = "marker", output_token = "Marker", limit_key = "limit", result_key = "UploadsList"),
    stream_api = FALSE
  )
  input <- .glacier$list_multipart_uploads_input(accountId = accountId, vaultName = vaultName, marker = marker, limit = limit)
  output <- .glacier$list_multipart_uploads_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_multipart_uploads <- glacier_list_multipart_uploads

#' This operation lists the parts of an archive that have been uploaded in
#' a specific multipart upload
#'
#' @description
#' This operation lists the parts of an archive that have been uploaded in a specific multipart upload. You can make this request at any time during an in-progress multipart upload before you complete the upload (see [`complete_multipart_upload`][glacier_complete_multipart_upload]. List Parts returns an error for completed uploads. The list returned in the List Parts response is sorted by part range.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_parts/](https://www.paws-r-sdk.com/docs/glacier_list_parts/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param marker An opaque string used for pagination. This value specifies the part at
#' which the listing of parts should begin. Get the marker value from the
#' response of a previous List Parts response. You need only include the
#' marker if you are continuing the pagination of results started in a
#' previous List Parts request.
#' @param limit The maximum number of parts to be returned. The default limit is 50. The
#' number of parts returned might be fewer than the specified limit, but
#' the number of returned parts never exceeds the limit.
#'
#' @keywords internal
#'
#' @rdname glacier_list_parts
glacier_list_parts <- function(accountId, vaultName, uploadId, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListPartsRequest",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    host_prefix = "",
    paginator = list(input_token = "marker", output_token = "Marker", limit_key = "limit", result_key = "Parts"),
    stream_api = FALSE
  )
  input <- .glacier$list_parts_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, marker = marker, limit = limit)
  output <- .glacier$list_parts_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_parts <- glacier_list_parts

#' This operation lists the provisioned capacity units for the specified
#' AWS account
#'
#' @description
#' This operation lists the provisioned capacity units for the specified AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_provisioned_capacity/](https://www.paws-r-sdk.com/docs/glacier_list_provisioned_capacity/) for full documentation.
#'
#' @param accountId &#91;required&#93; The AWS account ID of the account that owns the vault. You can either
#' specify an AWS account ID or optionally a single '-' (hyphen), in which
#' case Amazon S3 Glacier uses the AWS account ID associated with the
#' credentials used to sign the request. If you use an account ID, don't
#' include any hyphens ('-') in the ID.
#'
#' @keywords internal
#'
#' @rdname glacier_list_provisioned_capacity
glacier_list_provisioned_capacity <- function(accountId) {
  op <- new_operation(
    name = "ListProvisionedCapacity",
    http_method = "GET",
    http_path = "/{accountId}/provisioned-capacity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$list_provisioned_capacity_input(accountId = accountId)
  output <- .glacier$list_provisioned_capacity_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_provisioned_capacity <- glacier_list_provisioned_capacity

#' This operation lists all the tags attached to a vault
#'
#' @description
#' This operation lists all the tags attached to a vault. The operation returns an empty map if there are no tags. For more information about tags, see [Tagging Amazon S3 Glacier Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_tags_for_vault/](https://www.paws-r-sdk.com/docs/glacier_list_tags_for_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_list_tags_for_vault
glacier_list_tags_for_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "ListTagsForVault",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$list_tags_for_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$list_tags_for_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_tags_for_vault <- glacier_list_tags_for_vault

#' This operation lists all vaults owned by the calling user's account
#'
#' @description
#' This operation lists all vaults owned by the calling user's account. The list returned in the response is ASCII-sorted by vault name.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_list_vaults/](https://www.paws-r-sdk.com/docs/glacier_list_vaults/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param marker A string used for pagination. The marker specifies the vault ARN after
#' which the listing of vaults should begin.
#' @param limit The maximum number of vaults to be returned. The default limit is 10.
#' The number of vaults returned might be fewer than the specified limit,
#' but the number of returned vaults never exceeds the limit.
#'
#' @keywords internal
#'
#' @rdname glacier_list_vaults
glacier_list_vaults <- function(accountId, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListVaults",
    http_method = "GET",
    http_path = "/{accountId}/vaults",
    host_prefix = "",
    paginator = list(input_token = "marker", output_token = "Marker", limit_key = "limit", result_key = "VaultList"),
    stream_api = FALSE
  )
  input <- .glacier$list_vaults_input(accountId = accountId, marker = marker, limit = limit)
  output <- .glacier$list_vaults_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_vaults <- glacier_list_vaults

#' This operation purchases a provisioned capacity unit for an AWS account
#'
#' @description
#' This operation purchases a provisioned capacity unit for an AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_purchase_provisioned_capacity/](https://www.paws-r-sdk.com/docs/glacier_purchase_provisioned_capacity/) for full documentation.
#'
#' @param accountId &#91;required&#93; The AWS account ID of the account that owns the vault. You can either
#' specify an AWS account ID or optionally a single '-' (hyphen), in which
#' case Amazon S3 Glacier uses the AWS account ID associated with the
#' credentials used to sign the request. If you use an account ID, don't
#' include any hyphens ('-') in the ID.
#'
#' @keywords internal
#'
#' @rdname glacier_purchase_provisioned_capacity
glacier_purchase_provisioned_capacity <- function(accountId) {
  op <- new_operation(
    name = "PurchaseProvisionedCapacity",
    http_method = "POST",
    http_path = "/{accountId}/provisioned-capacity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$purchase_provisioned_capacity_input(accountId = accountId)
  output <- .glacier$purchase_provisioned_capacity_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$purchase_provisioned_capacity <- glacier_purchase_provisioned_capacity

#' This operation removes one or more tags from the set of tags attached to
#' a vault
#'
#' @description
#' This operation removes one or more tags from the set of tags attached to a vault. For more information about tags, see [Tagging Amazon S3 Glacier Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html). This operation is idempotent. The operation will be successful, even if there are no tags attached to the vault.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_remove_tags_from_vault/](https://www.paws-r-sdk.com/docs/glacier_remove_tags_from_vault/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param TagKeys A list of tag keys. Each corresponding tag is removed from the vault.
#'
#' @keywords internal
#'
#' @rdname glacier_remove_tags_from_vault
glacier_remove_tags_from_vault <- function(accountId, vaultName, TagKeys = NULL) {
  op <- new_operation(
    name = "RemoveTagsFromVault",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/tags?operation=remove",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$remove_tags_from_vault_input(accountId = accountId, vaultName = vaultName, TagKeys = TagKeys)
  output <- .glacier$remove_tags_from_vault_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$remove_tags_from_vault <- glacier_remove_tags_from_vault

#' This operation sets and then enacts a data retrieval policy in the
#' region specified in the PUT request
#'
#' @description
#' This operation sets and then enacts a data retrieval policy in the region specified in the PUT request. You can set one policy per region for an AWS account. The policy is enacted within a few minutes of a successful PUT operation.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_set_data_retrieval_policy/](https://www.paws-r-sdk.com/docs/glacier_set_data_retrieval_policy/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single '`-`'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens ('-') in the ID.
#' @param Policy The data retrieval policy in JSON format.
#'
#' @keywords internal
#'
#' @rdname glacier_set_data_retrieval_policy
glacier_set_data_retrieval_policy <- function(accountId, Policy = NULL) {
  op <- new_operation(
    name = "SetDataRetrievalPolicy",
    http_method = "PUT",
    http_path = "/{accountId}/policies/data-retrieval",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$set_data_retrieval_policy_input(accountId = accountId, Policy = Policy)
  output <- .glacier$set_data_retrieval_policy_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_data_retrieval_policy <- glacier_set_data_retrieval_policy

#' This operation configures an access policy for a vault and will
#' overwrite an existing policy
#'
#' @description
#' This operation configures an access policy for a vault and will overwrite an existing policy. To configure a vault access policy, send a PUT request to the `access-policy` subresource of the vault. An access policy is specific to a vault and is also called a vault subresource. You can set one access policy per vault and the policy can be up to 20 KB in size. For more information about vault access policies, see [Amazon Glacier Access Control with Vault Access Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_set_vault_access_policy/](https://www.paws-r-sdk.com/docs/glacier_set_vault_access_policy/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param policy The vault access policy as a JSON string.
#'
#' @keywords internal
#'
#' @rdname glacier_set_vault_access_policy
glacier_set_vault_access_policy <- function(accountId, vaultName, policy = NULL) {
  op <- new_operation(
    name = "SetVaultAccessPolicy",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$set_vault_access_policy_input(accountId = accountId, vaultName = vaultName, policy = policy)
  output <- .glacier$set_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_vault_access_policy <- glacier_set_vault_access_policy

#' This operation configures notifications that will be sent when specific
#' events happen to a vault
#'
#' @description
#' This operation configures notifications that will be sent when specific events happen to a vault. By default, you don't get any notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_set_vault_notifications/](https://www.paws-r-sdk.com/docs/glacier_set_vault_notifications/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param vaultNotificationConfig Provides options for specifying notification configuration.
#'
#' @keywords internal
#'
#' @rdname glacier_set_vault_notifications
glacier_set_vault_notifications <- function(accountId, vaultName, vaultNotificationConfig = NULL) {
  op <- new_operation(
    name = "SetVaultNotifications",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$set_vault_notifications_input(accountId = accountId, vaultName = vaultName, vaultNotificationConfig = vaultNotificationConfig)
  output <- .glacier$set_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_vault_notifications <- glacier_set_vault_notifications

#' This operation adds an archive to a vault
#'
#' @description
#' This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your data is durably persisted. Amazon S3 Glacier returns the archive ID in the `x-amz-archive-id` header of the response.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_upload_archive/](https://www.paws-r-sdk.com/docs/glacier_upload_archive/) for full documentation.
#'
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param archiveDescription The optional description of the archive you are uploading.
#' @param checksum The SHA256 tree hash of the data being uploaded.
#' @param body The data to upload.
#'
#' @keywords internal
#'
#' @rdname glacier_upload_archive
glacier_upload_archive <- function(vaultName, accountId, archiveDescription = NULL, checksum = NULL, body = NULL) {
  op <- new_operation(
    name = "UploadArchive",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/archives",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$upload_archive_input(vaultName = vaultName, accountId = accountId, archiveDescription = archiveDescription, checksum = checksum, body = body)
  output <- .glacier$upload_archive_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$upload_archive <- glacier_upload_archive

#' This operation uploads a part of an archive
#'
#' @description
#' This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them in parallel. You can upload up to 10,000 parts for a multipart upload.
#'
#' See [https://www.paws-r-sdk.com/docs/glacier_upload_multipart_part/](https://www.paws-r-sdk.com/docs/glacier_upload_multipart_part/) for full documentation.
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' '`-`' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you use an
#' account ID, do not include any hyphens ('-') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param checksum The SHA256 tree hash of the data being uploaded.
#' @param range Identifies the range of bytes in the assembled archive that will be
#' uploaded in this part. Amazon S3 Glacier uses this information to
#' assemble the archive in the proper sequence. The format of this header
#' follows RFC 2616. An example header is Content-Range:bytes 0-4194303/*.
#' @param body The data to upload.
#'
#' @keywords internal
#'
#' @rdname glacier_upload_multipart_part
glacier_upload_multipart_part <- function(accountId, vaultName, uploadId, checksum = NULL, range = NULL, body = NULL) {
  op <- new_operation(
    name = "UploadMultipartPart",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .glacier$upload_multipart_part_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, checksum = checksum, range = range, body = body)
  output <- .glacier$upload_multipart_part_output()
  config <- get_config()
  svc <- .glacier$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$upload_multipart_part <- glacier_upload_multipart_part
