% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{create_pain_model}
\alias{create_pain_model}
\title{Create a new pain model}
\usage{
create_pain_model(
  paw.features,
  strains = NULL,
  pain.stimulus = NULL,
  strain.standards = jones2020.standards,
  feature.set = c("post.peak", "pre.peak")
)
}
\arguments{
\item{paw.features}{the paw features returned by
\code{\link{extract_features}}}

\item{strains}{a vector containing strain information for each mouse}

\item{pain.stimulus}{a vector containing stimulus information for each mouse}

\item{strain.standards}{z-scores (centering and scaling) information
by strain}

\item{feature.set}{use either pre-peak or post-peak features}
}
\value{
pain model
}
\description{
Create a new pain model based on a set of paw features, corresponding pain
stimuli, and corresponding strain identity.
}
