% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSimUG2D.R
\name{IedgeCSbasic.tri}
\alias{IedgeCSbasic.tri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graphs of
Central Similarity Proximity Catch Digraphs (CS-PCDs) -
standard basic triangle case}
\usage{
IedgeCSbasic.tri(
  p1,
  p2,
  t,
  c1,
  c2,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity")
)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p2} or not
in the underlying or reflexivity graphs of CS-PCDs.}

\item{t}{A positive real number
which serves as the expansion parameter
in CS proximity region; must be \eqn{> 0}}

\item{c1, c2}{Positive real numbers
which constitute the vertex of the standard basic triangle
adjacent to the shorter edges;
\eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard basic triangle;
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_b}.}

\item{ugraph}{The type of the graph based on CS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of CS-PCDs
in the standard basic triangle, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of CS-PCDs \eqn{)}
for points \code{p1} and \code{p2} in the standard basic triangle.

More specifically, when the argument \code{ugraph="underlying"}, it returns
the edge indicator for the CS-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} or \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for the CS-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{CS}(p1,t)} and \code{p1} is in \eqn{N_{CS}(p2,t)},
returns 0 otherwise.

In both cases \eqn{N_{CS}(x,t)} is the CS proximity region for point \eqn{x}
with expansion parameter \eqn{t > 0}.
CS proximity region is defined with respect to
the standard basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is
in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Edge regions are based on the center, \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in
barycentric coordinates
in the interior of the standard basic triangle \eqn{T_b};
default is \eqn{M=(1,1,1)},
i.e., the center of mass of \eqn{T_b}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \eqn{T_b}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations (i.e., it allows loops).

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the original triangle.
Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

See also
(\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);

M<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)

t<-1.5

P1<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)
P2<-as.numeric(pcds::runif.basic.tri(1,c1,c2)$g)
IedgeCSbasic.tri(P1,P2,t,c1,c2,M)
IedgeCSbasic.tri(P1,P2,t,c1,c2,M,ugraph = "reflexivity")

P1<-c(.4,.2)
P2<-c(.5,.26)
IedgeCSbasic.tri(P1,P2,t=2,c1,c2,M)
IedgeCSbasic.tri(P1,P2,t=2,c1,c2,M,ugraph="ref")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgeCStri}}, \code{\link{IedgeASbasic.tri}},
\code{\link{IedgePEbasic.tri}} and \code{\link[pcds]{IarcCSbasic.tri}}
}
\author{
Elvan Ceyhan
}
