% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{PEarc.dens.tetra}
\alias{PEarc.dens.tetra}
\title{Arc density of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one tetrahedron case}
\usage{
PEarc.dens.tetra(Xp, th, r, M = "CM", th.cor = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{th.cor}{A logical argument for computing the arc density for only the points inside the tetrahedron,
\code{th}. (default is \code{th.cor=FALSE}), i.e., if \code{th.cor=TRUE} only the induced digraph
with the vertices inside \code{th} are considered in the computation of arc density.}
}
\value{
Arc density of PE-PCD whose vertices are the 2D numerical data set, \code{Xp};
PE proximity regions are defined with respect to the tetrahedron \code{th} and \code{M}-vertex regions
}
\description{
Returns the arc density of PE-PCD whose vertex set is the given 2D numerical data set, \code{Xp},
(some of its members are) in the tetrahedron \code{th}.

PE proximity region is constructed with respect to the tetrahedron \code{th} and
vertex regions are based on the center \code{M} which is circumcenter (\code{"CC"}) or
center of mass (\code{"CM"}) of \code{th} with default=\code{"CM"}.
For the number of arcs, loops are not
allowed so arcs are only possible for points inside the tetrahedron \code{th} for this function.

\code{th.cor} is a logical argument for tetrahedron correction (default is \code{TRUE}), if \code{TRUE}, only the points
inside the tetrahedron are considered (i.e., digraph induced by these vertices are considered) in computing
the arc density, otherwise all points are considered (for the number of vertices in the denominator of arc
density).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.5

num.arcsPEtetra(Xp,tetra,r,M)
PEarc.dens.tetra(Xp,tetra,r,M)
PEarc.dens.tetra(Xp,tetra,r,M,th.cor = FALSE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEarc.dens.tri}} and \code{\link{num.arcsPEtetra}}
}
\author{
Elvan Ceyhan
}
