% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{funsCSEdgeRegs}
\alias{funsCSEdgeRegs}
\alias{IarcCSstd.triRAB}
\alias{IarcCSstd.triRBC}
\alias{IarcCSstd.triRAC}
\title{Each function is for the presence of an arc from a point in one of the edge regions
to another for Central Similarity Proximity Catch Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
IarcCSstd.triRAB(p1, p2, t, M)

IarcCSstd.triRBC(p1, p2, t, M)

IarcCSstd.triRAC(p1, p2, t, M)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the CS proximity region of
\code{p1} or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}.}
}
\value{
Each function returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t))} for \code{p1}, that is, returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t)},
returns 0 otherwise
}
\description{
Three indicator functions: \code{IarcCSstd.triRAB}, \code{IarcCSstd.triRBC} and \code{IarcCSstd.triRAC}.

The function \code{IarcCSstd.triRAB} returns I(\code{p2} is in \eqn{N_{CS}(p1,t)} for \code{p1} in \eqn{RAB} (edge region for edge \eqn{AB},
i.e., edge 3) in the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))};

\code{IarcCSstd.triRBC} returns I(\code{p2} is in \eqn{N_{CS}(p1,t)} for \code{p1} in \eqn{RBC} (edge region for edge \eqn{BC}, i.e., edge 1) in \eqn{T_e};
and

\code{IarcCSstd.triRAC} returns I(\code{p2} is in \eqn{N_{CS}(p1,t)} for \code{p1} in \eqn{RAC} (edge region for edge \eqn{AC}, i.e., edge 2) in \eqn{T_e}.
That is, each function returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t)}, returns 0 otherwise.

CS proximity region is defined with respect to \eqn{T_e} whose vertices are also labeled as \eqn{T_e=T(v=1,v=2,v=3)}
with expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e}

If \code{p1} and \code{p2} are distinct and \code{p1} is outside the corresponding edge region and \code{p2} is outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their location (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
#Examples for IarcCSstd.triRAB
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T3<-rbind(A,B,CM);

set.seed(1)
Xp<-runif.std.tri(3)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

t<-1

IarcCSstd.triRAB(Xp[1,],Xp[2,],t,M)
IarcCSstd.triRAB(c(.2,.5),Xp[2,],t,M)
}

\donttest{
#Examples for IarcCSstd.triRBC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T1<-rbind(B,C,CM);

set.seed(1)
Xp<-runif.std.tri(3)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

t<-1

IarcCSstd.triRBC(Xp[1,],Xp[2,],t,M)
IarcCSstd.triRBC(c(.2,.5),Xp[2,],t,M)
}

\donttest{
#Examples for IarcCSstd.triRAC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T2<-rbind(A,C,CM);

set.seed(1)
Xp<-runif.std.tri(3)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

t<-1

IarcCSstd.triRAC(Xp[1,],Xp[2,],t,M)
IarcCSstd.triRAC(c(.2,.5),Xp[2,],t,M)
}

}
\seealso{
\code{\link{IarcCSt1.std.triRAB}}, \code{\link{IarcCSt1.std.triRBC}} and \code{\link{IarcCSt1.std.triRAC}}
}
\author{
Elvan Ceyhan
}
