% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genoCombinations.R
\name{genoCombinations}
\alias{genoCombinations}
\title{Genotype combinations}
\usage{
genoCombinations(x, partialmarker = x$MARKERS[[1]], ids, make.grid = TRUE)
}
\arguments{
\item{x}{a \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{partialmarker}{a \code{\link[pedtools:marker]{pedtools::marker()}} object compatible with \code{x}.}

\item{ids}{a vector with ID labels of one or more pedigree members.}

\item{make.grid}{a logical indicating if the result should be simplified to a
matrix.}
}
\value{
If \code{make.grid = FALSE} (the default) the function returns a list of
integer vectors, one vector for each element of \code{ids}. Each integer
represents a genotype, in the form of a row number of the matrix
\code{allGenotypes(n)}, where \code{n} is the number of alleles of the marker.

If \code{make.grid = TRUE}, the Cartesian product of the vectors is taken,
resulting in a matrix with one column for each element of \code{ids}.
}
\description{
Returns the possible genotype combinations in a pedigree, given partial
marker data. This function is mainly for internal use.
}
