% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sim_Rs}
\alias{sim_Rs}
\title{Simulate data (R, R0, R1, R2, R3 and R4)}
\usage{
sim_Rs(theta, pi0, n, alpha0 = 0, alpha = 0, beta = 0, seed = NULL, ...)
}
\arguments{
\item{theta}{A \code{numeric} that provides the true prevalence of a given disease.}

\item{pi0}{A \code{numeric} that provides the prevalence or proportion of people (in the whole population) who are positive, as measured through a non-random,
but systematic sampling (e.g. based on medical selection).}

\item{n}{A \code{numeric} that corresponds to the sample size.}

\item{alpha0}{A \code{numeric} that corresponds to the probability that a random participant
has been incorrectly declared positive through the nontransparent procedure. In most applications,
this probability is likely very close to zero. Default value is \code{0}.}

\item{alpha}{A \code{numeric} that provides the False Negative (FN) rate for the sample R. Default value is \code{0}.}

\item{beta}{A \code{numeric} that provides the False Positive (FP) rate for the sample R. Default value is \code{0}.}

\item{seed}{A \code{numeric} that provides the simulation seed. Default value is \code{NULL}.}

\item{...}{Additional arguments.}
}
\value{
A \code{cpreval_sim} object (\code{list}) with the structure:
\itemize{
\item R:      the number of participants in the survey sample that were tested positive.
\item R0:     the number of participants in the survey sample that were tested positive with the first testing device (and are, thus,  members of the sub-population).
\item R1:     the number of participants in the survey sample that were tested positive with both (medical) testing devices (and are, thus, members of the sub-population).
\item R2:     the number of participants in the survey sample that are tested positive only with the first testing device (and are, thus,  members of the sub-population).
\item R3:     the number of participants in the survey sample that are tested positive only with the second testing device.
\item R4:     the number of participants that are tested negative with the second testing device (and are either members of the sub-population and have tested negative with the first testing device or are not members of the sub-population).
\item n:      the sample size.
\item alpha:  the False Negative (FN) rate for the sample R.
\item beta:   the False Positive (FP) rate for the sample R.
\item alpha0: the alpha0 probability (as defined above).
\item ...:    additional arguments.
}
}
\description{
Simulation function for random variables of interest.
}
\examples{
# Samples without measurement error
sim_Rs(theta = 3/100, pi0 = 1/100, n = 1500, seed = 18)

# With measurement error
sim_Rs(theta = 3/100, pi0 = 1/100, n = 1500, alpha0 = 0,
alpha = 0.01, beta = 0.05, seed = 18)
}
\author{
Stephane Guerrier
}
