% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appearance_to_binary.R
\name{appearance_to_binary}
\alias{appearance_to_binary}
\title{Transform Amino Acid Appearance Probability into -1, 0, or 1}
\usage{
appearance_to_binary(x, threshold = 1.65, group = "Best", percentage = 0.05)
}
\arguments{
\item{x}{A data frame containing peptide sequences.}

\item{threshold}{The probability threshold to determine the transformation.}

\item{group}{A character string indicating which part of the data to consider. Either 'Best' or 'Worst'.}

\item{percentage}{The percentage of the data to consider, if group is specified.}
}
\value{
A matrix with the same dimensions as the input where each cell
has been transformed to -1, 0, or 1 based on the probability threshold.
}
\description{
This function transforms the counts of amino acids to a -1, 0, 1 matrix
based on a probability of appearance of each peptide in each position.
}
\examples{
# Generate a mock data frame
peptide_data <- data.frame(Sequence = c("ACGT", "TGCA", "GATC", "CGAT"))

# Apply the function to the mock data
appearance_to_binary(peptide_data, group = "Best", percentage = 0.5)
}
