% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_testing.R
\name{adjust_p_value}
\alias{adjust_p_value}
\title{Adjust p-values for multiple testing}
\usage{
adjust_p_value(pvalues, method = "holm-bonferroni")
}
\arguments{
\item{pvalues}{Array of p-values}

\item{method}{The FWER or FDR correction to use, either 'holm-bonferroni',
'bonferroni', or 'benjamini-hochberg'}
}
\value{
Adjusted p-values
}
\description{
This function takes an array of p-values and returns adjusted p-values using
user-inputted FWER or FDR correction method
}
\examples{
adjust_p_value(pvalues = c(.05, .1, .5), method='holm-bonferroni')

}
