% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencyPerDuration.R
\name{timesPerInterval}
\alias{timesPerInterval}
\alias{timesPerLifetime}
\alias{computeItemFrequencies}
\alias{computeLifetimeFrequencies}
\title{Frequency Per Duration.}
\usage{
timesPerInterval(
  num_occurrences = NULL,
  interval = NULL,
  duration = "month",
  not_occurred_past_year = NULL
)

timesPerLifetime(num_occurrences = NULL, never_occurred = NULL)

computeItemFrequencies(
  item_names,
  data,
  duration = "month",
  frequency_vars,
  interval_vars,
  not_in_past_year_vars
)

computeLifetimeFrequencies(
  item_names,
  data,
  frequency_vars,
  never_occurred_vars
)
}
\arguments{
\item{num_occurrences}{The number of times the behavior occurred during the
specified interval, \code{interval}.}

\item{interval}{The specified interval corresponding to the number of times
the behavior occurred, \code{num_occurrences}. One of:
\itemize{
  \item \code{1} = average number of times per day
  \item \code{2} = average number of times per week
  \item \code{3} = number of times in the past month
  \item \code{4} = number of times in the past year
}}

\item{duration}{The desired duration during which to estimate how many times
the behavior occurred:
\itemize{
  \item "day" = average number of times per day
  \item "week" = average number of times per week
  \item "month" = number of times in the past month
  \item "year" = number of times in the past year
}}

\item{not_occurred_past_year}{Whether or not the behavior did NOT occur in
the past year. If \code{0}, the behavior did occur in the past year. If
\code{1}, the behavior did not occur in the past year.}

\item{never_occurred}{Whether or not the behavior has NEVER occurred in
the person's lifetime. If \code{0}, the behavior has occurred in the
person's lifetime. If \code{1}, the behavior has never occurred in the
person's lifetime.}

\item{item_names}{The names of the questionnaire items.}

\item{data}{The data object.}

\item{frequency_vars}{The name(s) of the variables corresponding to the
number of occurrences (\code{num_occurrences}).}

\item{interval_vars}{The name(s) of the variables corresponding to the
intervals (\code{interval}).}

\item{not_in_past_year_vars}{The name(s) of the variables corresponding to
whether the behavior did not occur in the past year
(\code{not_occurred_past_year}).}

\item{never_occurred_vars}{The name(s) of the variables corresponding to
whether the behavior has never occurred during the person's lifetime
(\code{never_occurred}).}
}
\value{
The frequency of the behavior for the specified duration.
}
\description{
Estimate frequency of a behavior for a particular duration.
}
\details{
Estimates the frequency of a given behavior for a particular duration, given
a specified number of times it occurred during a specified interval.
}
\examples{
timesPerInterval(
  num_occurrences = 2,
  interval = 3,
  duration = "month",
  not_occurred_past_year = 0
)

timesPerInterval(
  duration = "month",
  not_occurred_past_year = 1
)

timesPerLifetime(
  num_occurrences = 2,
  never_occurred = 0
)

timesPerLifetime(
  never_occurred = 1
)
}
\concept{behaviorFrequency}
