% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-predprob.r
\name{predprob}
\alias{predprob}
\title{The predictive probability criterion function}
\usage{
predprob(y, n, nmax, alpha_e, beta_e, p_s, theta_t)
}
\arguments{
\item{y}{the number of responses among \eqn{n} patients treated by the experimental drug at a certain stage of the trial.}

\item{n}{the number of patients treated by the experimental drug at a certain stage of the trial.}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{alpha_e}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{beta_e}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{p_s}{the the response rate for the standard drug.}

\item{theta_t}{the prespecified target probability; tipically, \eqn{\theta_T = [0.85, 0.95]}.}
}
\value{
\item{prob}{the predictive probability: \eqn{PP = \sum_{x=0}^{n_{max}-n} P(x | y) I(\Pr(p_E > p_S | y, x) \geq \theta_T) }}
}
\description{
Lee and Liu's criterion function for determining the
trial decision cutoffs based on the predictive probability.
}
\examples{
# p. 97, PP = 0.5656
predprob(16, 23, 40, 0.6, 0.4, 0.6, 0.9)
}
\references{
Lee, J. J., Liu, D. D. (2008).
A predictive probability design for phase II cancer clinical trials.
\emph{Clinical Trials} \strong{5}: 93-106.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}
