% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bars.R
\name{plot_bars}
\alias{plot_bars}
\title{Plot \% of outcomes as bars}
\usage{
plot_bars(
  data,
  outcome,
  proportion,
  percentage_labelled,
  achieved,
  total,
  x_axis_title = NULL,
  y_axis_title = "\% Patients",
  legend_title = "Outcome",
  bar_fill = "Greys",
  grouping = NULL
)
}
\arguments{
\item{data}{A data frame containing outcomes data.}

\item{outcome}{Variable containing outcomes to be plotted.}

\item{proportion}{Variable containing proportion of patients who achieved the outcome.}

\item{percentage_labelled}{Variable containing percentage of patients who achieved the outcome,
suffixed with '\%' label.}

\item{achieved}{Variable containing number of patients who achieved the outcome.}

\item{total}{Variable containing total number of patients.}

\item{x_axis_title}{Title of the x-axis.}

\item{y_axis_title}{Title of the y-axis.}

\item{legend_title}{Title of the legend.}

\item{bar_fill}{Fill color of the bars.}

\item{grouping}{Faceting variable.}
}
\value{
A bar plot of outcome percentages.
}
\description{
Plot \% of outcomes as bars
}
\examples{
\donttest{
if (FALSE) {
library(phdcocktail)
data(ibd_outcomes, package = "phdcocktail")
plot_bars(ibd_outcomes)
  }
}

}
