% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_modis.R
\name{merge_modis}
\alias{merge_modis}
\title{Merge ORNL MODIS data with a PhenoCam time series}
\usage{
merge_modis(
  data,
  product,
  band,
  trim = FALSE,
  internal = TRUE,
  out_dir = tempdir()
)
}
\arguments{
\item{data}{a PhenoCam data file or data structure}

\item{product}{which MODIS product to query (character vector)}

\item{band}{which MODIS band(s) to include (character vector)}

\item{trim}{logical, trim the MODIS data to the length of the
PhenoCam time series or include the whole Daymet time series (1980-current).
(default = \code{FALSE})}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data (default = tempdir())}
}
\value{
A PhenoCam data structure or file which combines PhenoCam time series
data with MODIS values (columns will be added). Data is queried from the
ORNL MODIS subsets service using the `MODISTools` package, please consult 
either sources on product and band names.
}
\description{
Combine PhenoCam time series with MODIS data for matching dates.
}
\examples{

\dontrun{
# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3")

# merge data with daymet data
df <-  merge_modis(file.path(tempdir(),
"harvard_DB_1000_3day.csv"),
product = "MOD13Q1",
band = "250m_16_days_NDVI")
}
}
