% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi_delta.R
\name{phiDelta.plot}
\alias{phiDelta.plot}
\title{Plot of phi delta diagram}
\usage{
phiDelta.plot(phi, delta, ratio = 1, names = NULL, border = "red",
  filling = "grey", crossing = TRUE, iso_specificity = FALSE,
  iso_sensitivity = FALSE, iso_neg_predictive_value = FALSE,
  iso_precision = FALSE, iso_accuracy = FALSE, highlighted = NULL)
}
\arguments{
\item{phi}{numeric value or vector of phi}

\item{delta}{numeric value or vector of delta}

\item{ratio}{numeric, is the ratio of positive and negative of the data}

\item{names}{string with feature names}

\item{border}{the color of the border of the shape.  NA for no border}

\item{filling}{the color to fill the shape with}

\item{crossing}{logical, if the crossing should be drawn}

\item{iso_specificity}{logical, if isometric lines of the specificity should be drawn}

\item{iso_sensitivity}{logical, if isometric lines of the sensitivity should be drawn}

\item{iso_neg_predictive_value}{logical, if isometric lines of the negative predictive value should be drawn}

\item{iso_precision}{logical, if isometric lines of the precision should be drawn}

\item{iso_accuracy}{logical, if isometric lines of the accuracy should be drawn}

\item{highlighted}{numeric vector, indices of the points to higlight
highlighted points will be orange}
}
\description{
Plots delta against phi within the phi delta diagram shape
}
\examples{
x <- climate_data
phiDelta <- phiDelta.stats(x[,-1],x[,1])
phiDelta.plot(phiDelta$phi, phiDelta$delta)
phiDelta.plot(phiDelta$phi, phiDelta$delta,
  ratio = phiDelta$ratio,
  border = "green",
  iso_neg_predictive_value = TRUE,
  crossing = FALSE)
}
\author{
rothe
}
