% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fin_year.R
\name{extract_fin_year}
\alias{extract_fin_year}
\title{Extract the formatted financial year from a date}
\usage{
extract_fin_year(date)
}
\arguments{
\item{date}{A date which must be supplied with \code{Date}, \code{POSIXct}, \code{POSIXlt} or
\code{POSIXt} class. \code{\link[base:as.Date]{base::as.Date()}},
\code{\link[lubridate:ymd]{lubridate::dmy()}} and
\code{\link[base:as.POSIXlt]{as.POSIXct()}} are examples of functions which
can be used to store dates as an appropriate class.}
}
\value{
A character vector of financial years in the form '2017/18'.
}
\description{
\code{extract_fin_year} takes a date and extracts the
correct financial year in the PHS specified format from it.
}
\details{
The PHS accepted format for financial year is YYYY/YY e.g. 2017/18.
}
\examples{
x <- lubridate::dmy(c(21012017, 04042017, 17112017))
extract_fin_year(x)
}
