% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_roc_threshold.R
\name{optim_roc_threshold}
\alias{optim_roc_threshold}
\title{Find optimal ROC threshold}
\usage{
optim_roc_threshold(roc)
}
\arguments{
\item{roc}{a dataframe produced by the \code{gendist_roc_format()} function containing the Receiver Operating Characteristic (ROC) curve}
}
\value{
vector containing optimal thresholds of sensitivity and specificity
}
\description{
This function takes the dataframe output of the \code{gendist_roc_format()} function and finds the optimal threshold
of sensitivity and specificity by minimizing the distance to the top left corner of the Receiver Operating Characteristic (ROC) curve
}
\examples{
# ebola-like pathogen
R <- 1.5
mut_rate <- 1

# use simulated generation distributions
data("genDistSim")
mean_gens_pdf <- as.numeric(genDistSim[genDistSim$R == R, -(1:2)])

# get theoretical genetic distance dist based on mutation rate and generation parameters
dists <- as.data.frame(gendist_distribution(mut_rate = mut_rate,
                       mean_gens_pdf = mean_gens_pdf,
                       max_link_gens = 1))

# reshape dataframe for plotting
dists <- reshape2::melt(dists,
                        id.vars = "dist",
                        variable.name = "status",
                        value.name = "prob")

# get sensitivity and specificity using the same paramters
roc_calc <- gendist_roc_format(cutoff = 1:(max(dists$dist)-1),
                          mut_rate = mut_rate,
                          mean_gens_pdf = mean_gens_pdf)

# get the optimal value for the ROC plot
optim_point <- optim_roc_threshold(roc_calc)

}
\seealso{
Other ROC functions: 
\code{\link{gendist_roc_format}()}
}
\author{
Shirlee Wohl, John Giles, and Justin Lessler
}
\concept{ROC functions}
