% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloSignalExtra.R
\name{phyloSignalINT}
\alias{phyloSignalINT}
\title{Computes phylogenetic signal at each internal node of a phylogeny}
\usage{
phyloSignalINT(
  p4d,
  trait = names(tipData(p4d))[1],
  method = "Cmean",
  reps = 999,
  W = NULL
)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{trait}{a character string giving the trait to use to compute the signal. By default the first trait is taken from \code{p4d}.}

\item{method}{a character vector giving the method to use to compute phylogenetic signal
(default is "\code{Cmean}"; see \code{\link{phyloSignal}}).}

\item{reps}{an integer. The number of repetitions for the estimation of p.values with randomization.}

\item{W}{an optional matrix of phylogenetic weights to compute Moran's I. By default the matrix
is computed with the function \code{\link[adephylo]{proxTips}} with patristic distances.}
}
\value{
A \code{phylo4d} object with phylogenetic signal statistics and p-values as nodes associated data.
}
\description{
This function computes phylogenetic signal statistics and p-values for a given trait
and a given method at each internal node of a phylogenetic tree.
}
