% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.piar_index.R
\name{stack.piar_index}
\alias{stack.piar_index}
\alias{stack.chainable_piar_index}
\alias{stack.direct_piar_index}
\alias{unstack.chainable_piar_index}
\alias{unstack.direct_piar_index}
\title{Stack price indexes}
\usage{
\method{stack}{chainable_piar_index}(x, y, ...)

\method{stack}{direct_piar_index}(x, y, ...)

\method{unstack}{chainable_piar_index}(x, ...)

\method{unstack}{direct_piar_index}(x, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elementary_index]{elementary_index()}}.}

\item{y}{A price index, or something that can coerced into one. If \code{x}
is a period-over-period index then \code{y} is coerced into a chainable
index; otherwise, \code{y} is coerced into a direct index.}

\item{...}{Not currently used.}
}
\value{
\code{stack()} returns a combined price index that inherits from the same class
as \code{x}.

\code{unstack()} returns a list of price indexes with the same class as \code{x}.
}
\description{
\code{stack()} combines two price indexes with common levels, stacking index
values and percent-change contributions for one index after the other.

\code{unstack()} breaks up a price index into a list of indexes for each
time period.

These methods can be used in a map-reduce to make an index with multiple
aggregation structures (like a Paasche index).
}
\note{
It may be necessary to use \code{rebase()} prior to stacking fixed-based price
indexes to ensure they have the same base period.
}
\examples{
index1 <- as_index(matrix(1:6, 2))

index2 <- index1
time(index2) <- 4:6

stack(index1, index2)

# Unstack does the reverse

all.equal(
  c(unstack(index1), unstack(index2)),
  unstack(stack(index1, index2))
)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
