% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_dospaces.R
\name{legacy_dospace}
\alias{legacy_dospace}
\alias{board_register_dospace}
\title{DigitalOcean board (legacy API)}
\usage{
legacy_dospace(
  space = Sys.getenv("DO_SPACE"),
  key = Sys.getenv("DO_ACCESS_KEY_ID"),
  secret = Sys.getenv("DO_SECRET_ACCESS_KEY"),
  datacenter = Sys.getenv("DO_DATACENTER"),
  cache = NULL,
  host = "digitaloceanspaces.com",
  name = "dospace",
  ...
)

board_register_dospace(
  name = "dospace",
  space = Sys.getenv("DO_SPACE"),
  key = Sys.getenv("DO_ACCESS_KEY_ID"),
  secret = Sys.getenv("DO_SECRET_ACCESS_KEY"),
  datacenter = Sys.getenv("DO_DATACENTER"),
  cache = NULL,
  host = "digitaloceanspaces.com",
  path = NULL,
  ...
)
}
\arguments{
\item{space}{The name of the DigitalOcean space.}

\item{key, secret}{The key and secret for your space. You can create
a key and secret in the "Spaces access keys" in your API settings.

The \code{secret} is equivalent to a password, so generally should not be stored
in your script. The easiest alternative is to store it in the
\code{DO_SECRET_ACCESS_KEY} environment variable, which \code{legacy_dospace()} will
use by default.}

\item{datacenter}{The datacenter name.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{host}{The host to use for storage, defaults to \code{"digitaloceanspaces.com"}.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{...}{Additional parameters required to initialize a particular board.}

\item{path}{Subdirectory within \code{url}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
To use DigitalOcean Spaces as a board, you first
need an DigitalOcean space and a storage key. You can sign-up and create
those at \href{https://www.digitalocean.com/}{digitalocean.com}.
}
\examples{
\dontrun{
# the following example requires a DigitalOcean Spaces API key
board <- legacy_dospace(bucket = "s3bucket")
}
}
\keyword{internal}
