% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipebind.R
\name{bind}
\alias{bind}
\alias{lambda}
\alias{pipebind}
\title{Bind a (piped) object to a symbol for complex function evaluation}
\usage{
bind(.pipeValue, .pipeBind, ...)
}
\arguments{
\item{.pipeValue}{The object to bind. Typically specified by piping into the
\code{bind()} function (e.g., \code{x |> bind()}).}

\item{.pipeBind}{The placeholder symbol to use to represent the piped object.
Can be any valid R object name.}

\item{...}{An R expression. Any valid R code (expression).}
}
\value{
The results of the expression, evaluated using the piped object.
}
\description{
The \link[base:pipeOp]{base R} \code{\link[base:pipeOp]{|>}} \link[base:pipeOp]{pipe}
lacks some advanced functionality compared to the
\href{https://magrittr.tidyverse.org/reference/pipe.html}{\code{{magrittr}} \verb{\%>\%} pipe}.
For example, the piped object can only appear once on the right-hand
side of the pipe (either as the first unnamed argument or elsewhere using the
\verb{_} placeholder in R 4.2.0 and later), and the \verb{_} placeholder cannot
appear on the left side of sub-setting functions like \code{$}, \code{[}, \code{[[}, or \code{@}.

The \code{bind()} function is a way to conveniently circumvent these limitations.
Pipe an object into \code{bind()}, choose a placeholder symbol to represent it,
then use this placeholder to refer the piped object in any way and as many
times as desired in an R expression.

The Greek letter
\ifelse{latex}{\out{$\lambda$}\code{()}}{\ifelse{html}{\out{&lambda;}\code{()}}{λ()}}
is available as an alias for \code{bind()}.
}
\examples{
# Piping to a non-first argument
mtcars |>
  transform(kmL = mpg / 2.35) |>
  bind(d, lm(kmL ~ hp, data = d))

# Using the piped value multiple times
rnorm(10, mean = 10) |>
  bind(x, x - mean(x))

# Using the piped value in multiple arguments
c(a = 1, b = 2, c = 3) |>
  bind(x, paste(names(x), x, sep = " = "))

# Subsetting the piped value
mtcars |>
  bind(d, d$mpg)
}
