#' get_apps_list fetch all apps
#'
#' @param token login token generated by \code{\link{get_login_token}}
#'
#' @return data.frame
#' @export
#'
get_apps_list <- function(token) {
  get_generic_list(token, 0, "/api/apps/v2",
                   c('type', 'id', 'name', 'addedAt', 'updatedAt'),
                   c('addedAt', 'updatedAt'))
}


#' get_metasites_list
#'
#' @param token login token generated by \code{\link{get_login_token}}
#'
#' @return data.frame
#' @export
#'
get_metasites_list <- function(token) {
  get_generic_list(token, 0, "/api/meta-sites/v1",
                   c('type', 'id', 'name', 'created_at', 'updated_at'),
                   c('created_at', 'updated_at'))
}

#' get_permissions_for_app
#'
#' @param token login token generated by \code{\link{get_login_token}}
#' @param app app id, see \code{\link{get_apps_list}}
#'
#' @return data.frame
#' @export

get_permissions_for_app <- function(token, app) {

  permission_levels <- c('no-access', 'view', 'edit', 'edit-publish', 'manage')


  get_generic_list(token, 0, glue::glue("/api/access-control/v2/app/{app}/permission/user"),
                   c('type', 'id', 'email', 'permission', 'group_permissions'),
                   c()) %>%
    dplyr::rowwise() %>%
    dplyr::filter(! is.list(.data$group_permissions)) %>%
    tidyr::unnest(.data$group_permissions) %>%
    dplyr::mutate(dplyr::across(dplyr::all_of(c("permission", "group_permissions")),
                                ~factor(., levels = permission_levels,
                                        ordered = TRUE))) %>%
    dplyr::rowwise() %>%
    dplyr::mutate(
      overall_permissions = max(.data$permission, .data$group_permissions)
    )
}

#' get_permissions_for_metasite
#'
#' @param token login token generated by \code{\link{get_login_token}}
#' @param metasite app id, see \code{\link{get_metasites_list}}
#'
#' @return data.frame
#' @export

get_permissions_for_metasite <- function(token, metasite) {

  permission_levels <- c('no-access', 'view', 'edit', 'edit-publish', 'manage')


  get_generic_list(token, 0, glue::glue("/api/access-control/v2/meta-site/{metasite}/permission/user"),
                   c('type', 'id', 'email', 'permission', 'group_permissions'),
                   c()) %>%
    dplyr::rowwise() %>%
    dplyr::filter(! is.list(.data$group_permissions)) %>%
    tidyr::unnest(.data$group_permissions) %>%
    dplyr::mutate(dplyr::across(dplyr::all_of(c("permission", "group_permissions")),
                                ~factor(., levels = permission_levels,
                                        ordered = TRUE))) %>%
    dplyr::rowwise() %>%
    dplyr::mutate(
      overall_permissions = max(.data$permission, .data$group_permissions)
    )
}
