% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pks.R
\name{compare_pks}
\alias{compare_pks}
\title{Compare two answers of the PK values.}
\usage{
compare_pks(pk1, pk2)
}
\arguments{
\item{pk1}{a list, the output of the function calculate_pk().}

\item{pk2}{a list, the output of the function calculate_pk().}
}
\value{
a list containing all the variables during the calculation.
    The value list$type is "PKC", which indicated the list is the return-value of the function compare_pk().
    The type of list$group is also a list, which contains the normal distribution test results for the group variables.
    The type of list$pair is also a list, which contains the t distribution test results for the pair variables.
    The type of list$details is also a list, which contains all the intermediate variables during the calculation.
}
\description{
Both of the two input have to be the output of the function calculate_pk().
}
\examples{
x1 <- c(1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6)
y1 <- c(1, 1, 1, 1, 1, 2, 1, 1, 3, 3, 2, 2, 2, 2, 2, 1, 3, 3, 3, 3, 3, 3, 3, 3)

pk1 <- calculate_pk(x_in = x1, y_in = y1)
print(pk1$basic)

x2 <- c(1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6)
y2 <- c(1, 1, 2, 1, 1, 2, 1, 2, 3, 3, 2, 2, 1, 2, 2, 2, 3, 3, 3, 3, 2, 3, 3, 2)

pk2 <- calculate_pk(x_in = x2, y_in = y2)
print(pk2$basic)

ans <- compare_pks(pk1, pk2)
print(ans$group)
print(ans$pair)
}
\references{
Warren D. Smith, Robert C. Dutton, Ty N. Smith; Measuring the Performance of Anesthetic Depth Indicators. 
    Anesthesiology 1996; 84:38–51 doi: https://doi.org/10.1097/00000542-199601000-00005.

Warren D. Smith, Robert C. Dutton, Ty N. Smith; A measure of association for assessing prediction accuracy 
    that is a generalization of nonparametric ROC area. Statistics in Medicine 1996; 15: 1119-1215 
    doi: https://doi.org/10.1002/(SICI)1097-0258(19960615)15:11<1199::AID-SIM218>3.0.CO;2-Y.
}
