% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_content}
\alias{remove_content}
\title{Remove content lines from a pkglite file}
\usage{
remove_content(input, x, quiet = FALSE)
}
\arguments{
\item{input}{Path to the text file.}

\item{x}{A character vector.
Exactly matched lines in the file content will be removed.}

\item{quiet}{Suppress printing of progress?}
}
\value{
The input file path.
}
\description{
Remove content lines from a pkglite file
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Read the input file as a character vector.
    \item Identify the line numbers that belong to the Content field by the indentation.
    \item Extract these lines and remove the two heading whitespaces and store as a vector.
    \item Find the elements that match the values in the input vector \code{x}.
    \item Remove the matching elements.
    \item Write the file back with the matching elements removed.
    \item If there are any matching elements and \code{quiet = FALSE},
    print the line numbers being removed.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
pkg <- system.file("examples/pkg1", package = "pkglite")
txt <- tempfile(fileext = ".txt")

pkg \%>\%
  collate(file_default()) \%>\%
  pack(output = txt, quiet = TRUE) \%>\%
  remove_content(c("## New Features", "## Improvements"), quiet = TRUE)
}
