% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FARAO.R
\name{FARAO}
\alias{FARAO}
\alias{FARAO2}
\title{FARquhar And Opti}
\usage{
FARAO(
  lambda = 0.002,
  Ca = 400,
  VPD = 1,
  photo = c("BOTH", "VCMAX", "JMAX"),
  energybalance = FALSE,
  C4 = FALSE,
  Tair = 25,
  Wind = 2,
  Wleaf = 0.02,
  StomatalRatio = 1,
  LeafAbs = 0.86,
  ...
)

FARAO2(lambda = 0.002, Ca = 400, energybalance = FALSE, ...)
}
\arguments{
\item{lambda}{The marginal cost of water (mol mol-1)}

\item{Ca}{The CO2 concentration.}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{photo}{Which photosynthesis rate should stomata respond to? Defaults to 'BOTH', i.e. 
the minimum of Vcmax and Jmax limited rates.}

\item{energybalance}{If TRUE (Default = FALSE), calculates leaf temperature from energy balance 
(and its effects on photosynthesis as well as leaf transpiration), using \code{\link{PhotosynEB}}.}

\item{C4}{If TRUE, uses the C4 photosynthesis routine (\code{\link{AciC4}})}

\item{Tair}{Air temperature (deg C)}

\item{Wind}{Wind speed (m s-1) (only used if energybalance=TRUE)}

\item{Wleaf}{Leaf width (m) (only used if energybalance=TRUE)}

\item{StomatalRatio}{The stomatal ratio (see \code{\link{PhotosynEB}}) (only used if 
energybalance=TRUE)}

\item{LeafAbs}{Leaf absorptance (see \code{\link{PhotosynEB}}) (only used if 
energybalance=TRUE)}

\item{...}{All other parameters are passed to \code{\link{Aci}}}
}
\description{
The numerical solution of the optimal stomatal conductance model, coupled with 
the Farquhar model of photosynthesis. The model of Medlyn et al. (2011) is an approximation 
to this full numeric solution.
}
\details{
This model finds the Ci that maximizes A - lambda*E (Cowan & Farquhar 1977,
 see also Medlyn et al. 2011). The new function FARAO2 is a much simpler (and probably 
 more stable) implementation, based on Buckley et al. 2014 (P,C&E). Both functions 
 are provided, as FARAO has a few more options than FARAO2, at the moment.
}
\references{
Buckley, T.N., Martorell, S., Diaz-Espejo, A., Tomas, M., Medrano, H., 2014. Is stomatal 
conductance optimized over both time and space in plant crowns? A field test in 
grapevine (Vitis vinifera). Plant Cell Environ doi:10.1111/pce.12343

Cowan, I. and G.D. Farquhar. 1977. Stomatal function in relation to leaf metabolism 
and environment. Symposia of the Society for Experimental Biology. 31:471-505.

Medlyn, B.E., R.A. Duursma, D. Eamus, D.S. Ellsworth, I.C. Prentice, C.V.M. Barton, 
K.Y. Crous, P. De Angelis, M. Freeman and L. Wingate. 2011. Reconciling the optimal 
and empirical approaches to modelling stomatal conductance. Global Change Biology. 17:2134-2144.
}
\author{
Remko Duursma
}
