% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pleioR.R
\name{pleioR}
\alias{pleioR}
\title{Fit a multi-trait model to test for genetic pleiotropy}
\usage{
pleioR(pheno, geno, i = NULL, j = NULL, covariates = NULL, drop_subsets = 10)
}
\arguments{
\item{pheno}{dataframe with phenotypic data. Must have columns 'id', 'trait', and 'y'. Column 'y' must contain the observations for the corresponding 'trait' and 'id'. See function melt() in the 'reshape2' package for a simple formatting of your data.}

\item{geno}{matrix with SNPs in columns and IDs in rownames. This can also be a memory-mapped matrix returned by BEDMatrix() in the 'BEDMatrix' package.}

\item{i}{integers indexing rows from geno to use in the model.}

\item{j}{integers indexing columns from geno to use in the model. Useful when working with multiple jobs in parallel.}

\item{covariates}{(optional) dataframe or matrix containing covariates in columns and IDs as rownames. These IDs must match those in geno.}

\item{drop_subsets}{minimum sample size of sub-data sets to consider for analysis, 10 by default. When working with unbalanced data (a.k.a. fragmented data), save computation time by dropping small fragments of data.}
}
\value{
pleio_class list of left and right hand side solutions of the model.
}
\description{
Fits a seemingly unrelated regression with, possibly unbalanced data, and/or covariates. It returns a pleio_class object to perform the sequential test with pleio_test() or to obtain by-trait estimates with mt_gwas().
}
\examples{
# Random generated example with 3 traits, 1e4 individuals, 1000 SNPs and 10\% missing values.
sim1 <- pleio_simulate(n_traits = 3, n_individuals = 1e4, n_snp = 1e3, percentage_mv = 0.1)
pleio_model <- pleioR(pheno = sim1$pheno, geno = sim1$geno)
pleio_model_test <- pleio_test(pleio_model)
}
