% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pleio_ideogram.R
\name{pleio_ideogram}
\alias{pleio_ideogram}
\title{Plot ideogram from pleio_test results}
\usage{
pleio_ideogram(
  pleio_res,
  alpha = "bonferroni05",
  n_traits = 2,
  bp_positions,
  window_size = 1e+06,
  centromeres = NULL,
  color_bias = 1,
  set_plot = T,
  set_legend = T,
  set_ylim_prop = 1.1,
  ...
)
}
\arguments{
\item{pleio_res}{list returned by pleio_test().}

\item{alpha}{numeric threshold for significance level (Bonferroni correction by default).}

\item{n_traits}{integer indicating the level of pleiotropy to test (a.k.a. number of traits).}

\item{bp_positions}{dataframe with colnames 'chr' and 'pos' indicating the chromosome and position for each SNP. Rownames must contain SNP names matching results of pleio_test.}

\item{window_size}{numeric value indicating the minimum size (in base pairs) of the genomic region that contains significant SNPs.}

\item{centromeres}{string 'human' or dataframe (or matrix) with chromosome and position (in mbp) of the centromeres in the first and second columns. If NULL (default) does not plot the centromeres.}

\item{color_bias}{number for bias of the color scale. See help(colorRampPalette). By default color_bias = 1}

\item{set_plot}{logical indicating whether to plot the ideogram (TRUE by default).}

\item{set_legend}{logical indicating whether to plot a legend (TRUE by default).}

\item{set_ylim_prop}{numeric proportion of upper margin to fit the legend (no margin by default). 1 = no margin, 1.1 = 10\% left for margin, etc.}

\item{...}{more plot arguments.}
}
\value{
Ideogram plot and a dataframe with genomic segments information.
}
\description{
Plots genomic segments that contain significant pleiotropic SNPs using results of pleio_test(). It also returns a dataframe with segment information.
}
\seealso{
\code{\link{pleio_plot}}
}
