% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pleio_test.R
\name{pleio_test}
\alias{pleio_test}
\title{Sequential Wald test for pleiotropy}
\usage{
pleio_test(
  pleio_results,
  loop_breaker = 1,
  save_at = NULL,
  contrast_matrices_list = NULL
)
}
\arguments{
\item{pleio_results}{pleio_class object returned by pleioR().}

\item{loop_breaker}{numeric value for a maximum p-value used to stop the sequence if a higher p-value is obtained. This saves computation time if there are many tests to perform.}

\item{save_at}{character with directory and/or file name (.rdata) to save the results. This is useful when handling multiple results such as in parallel jobs.}

\item{contrast_matrices_list}{user-specified contrast matrices within a list of lists, or a single contrast matrix (see example). Each matrix must have the same number of columns, and must be equal to the number of traits.}
}
\value{
list of p-values, indices, and trait numeric identifier.
}
\description{
Performs the sequential test of pleiotropic effects using results of pleioR().
}
\examples{
# Example of user-specified contrast matrices with 3 traits
cm1 <- matrix(c(-1, 0, 1), ncol = 3)
cm2 <- matrix(c(0, -1, 1), ncol = 3)
contrast_matrices <- list('1vs3' = list(cm1), '2vs3' = list(cm2))
# or a single contrast matrix as:
contrast_matrices <- cm1
}
