% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel.R
\name{readGRM}
\alias{readGRM}
\title{Read Genetic Related Matrix (GRM) of GCTA}
\usage{
readGRM(pfx, fid = NULL)
}
\arguments{
\item{pfx}{prefix of GRM file set}

\item{fid}{separator after family ID (def=NULL, use IID only)}
}
\value{
matrix of relatedness with sample ID in row and column names.
}
\description{
GRM is the  core formt of GCTA,  which is an binary symmetric  matrix with an
extra variant count  matrix (VCM), this function reads  the binary sysmmetric
matrix.
}
\details{
GCTA GRM is represented by a set of three files:

\describe{
\item{.grm.bin   :}{GRM matrix in binary}
\item{.grm.id    :}{sample FID and IID in text}
\item{.grm.N.bin :}{number of valid variants for each GRM entry}}

and it always  uses single precision (4  bytes per entry).

To read the extra the extra VCM (grm.N.bin), use \code{\link{readVCM}}.
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20")
(readGRM(pfx))

}
