% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-bases.R
\name{create_bases}
\alias{create_bases}
\title{Generate bases function matrix}
\usage{
create_bases(t, keep = NULL)
}
\arguments{
\item{t}{A vector representing the timepoints for which basis functions are generated.}

\item{keep}{(Optional) A vector specifying the indices of the basis functions to retain.
If not provided, all generated basis functions are retained.}
}
\value{
A list with the following components:
\item{bases}{A matrix containing the generated bases function.}
\item{selected_bases}{A vector containing the indices of the selected basis functions after applying \code{\link{filter_nonzero_bases}}.
If the \code{keep} argument is provided, \code{\link{filter_nonzero_bases}} is applied exclusively to the functions specified in \code{keep}.}
}
\description{
The \code{create_bases} function generates a matrix of bases functions for modeling time.
The bases function matrix include Fourier basis functions and polynomial basis functions.
}
\details{
The function constructs two types of basis functions: Fourier basis functions and polynomial basis functions.
Fourier basis functions are constructed based on the maximum timepoint (\code{max_t}) and the input timepoints \code{t}.
Polynomial basis functions are constructed with degrees ranging from 0.1 to 2, incrementing by 0.02.
}
\examples{
t <- seq(0, 10, by = 0.5)
bases <- create_bases(t)
selected_bases <- create_bases(t)
selected_bases[[1]]
selected_bases[[2]]
}
\seealso{
\code{\link{filter_nonzero_bases}}
}
