% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune-plmm.R
\name{tune_plsmm}
\alias{tune_plsmm}
\title{Tune Penalized PLSMM}
\usage{
tune_plsmm(
  x,
  y,
  series,
  t,
  name_group_var,
  bases,
  gamma_vec,
  lambda_vec,
  timexgroup,
  criterion,
  ...
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A continuous vector of response variable.}

\item{series}{A variable representing different series or groups in the data modeled as a random intercept.}

\item{t}{A numeric vector indicating the time points.}

\item{name_group_var}{A character string specifying the name of the grouping variable.}

\item{bases}{A matrix of bases functions.}

\item{gamma_vec}{A vector of values for the regularization parameter for the coefficients of the nonlinear functions.}

\item{lambda_vec}{A vector of values for the regularization parameter for the coefficients of the fixed effects.}

\item{timexgroup}{Logical indicating whether to use a time-by-group interaction.
If \code{TRUE}, each group in \code{name_group_var} will have its own estimate of the time effect.}

\item{criterion}{A character string specifying the criterion to be optimized (\code{'BIC'}, \code{'BICC'}, \code{'EBIC'}).}

\item{...}{Additional arguments to be passed to the \code{plsmm_lasso} function.}
}
\value{
A PLSMM object representing the best-tuned model based on the specified criterion.
}
\description{
This function tunes a penalized partial linear semiparametric mixed-model (PLSMM) by performing a grid search
over a set of hyperparameters to find the best model based on a given criterion.
}
\details{
This function performs a grid search over the hyperparameters specified by \code{lambda_vec}
and \code{gamma_vec} to find the best-fitted PLSMM based on the given criterion. It fits PLSMMs using the
\code{plsmm_lasso} function for each combination of hyperparameters and retains only the models that
have converged. The best model is selected based on the minimum value of the specified criterion.
}
\examples{
set.seed(123)
data_sim <- simulate_group_inter(
 N = 50, n_mvnorm = 3, grouped = TRUE,
 timepoints = 3:5, nonpara_inter = TRUE,
 sample_from = seq(0, 52, 13),
 cos = FALSE, A_vec = c(1, 1.5)
)
sim = data_sim$sim
x = as.matrix(sim[,-1:-3])
y = sim$y
series = sim$series
t = sim$t
bases = create_bases(t)
lambdas <- c(0.0046, 0.0001)
gammas <- 0.00000001
tuned_plsmm <- tune_plsmm(x, y, series, t,
                      name_group_var = "group", bases$bases,
                      gamma_vec = gammas, lambda_vec = lambdas, timexgroup = TRUE,
                      criterion = "BIC"
)

}
\seealso{
\code{\link{plsmm_lasso}}
}
