% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_constructor.R
\name{openapi}
\alias{openapi}
\alias{openapi_info}
\alias{openapi_contact}
\alias{openapi_license}
\alias{openapi_path}
\alias{openapi_operation}
\alias{openapi_parameter}
\alias{openapi_header}
\alias{openapi_schema}
\alias{openapi_content}
\alias{openapi_request_body}
\alias{openapi_response}
\alias{openapi_tag}
\title{Construct OpenAPI specifications}
\usage{
openapi(
  openapi = "3.0.0",
  info = openapi_info(),
  paths = list(),
  tags = list()
)

openapi_info(
  title = character(),
  description = character(),
  terms_of_service = character(),
  contact = openapi_contact(),
  license = openapi_license(),
  version = character()
)

openapi_contact(name = character(), url = character(), email = character())

openapi_license(name = character(), url = character())

openapi_path(
  summary = character(),
  description = character(),
  get = openapi_operation(),
  put = openapi_operation(),
  post = openapi_operation(),
  delete = openapi_operation(),
  options = openapi_operation(),
  head = openapi_operation(),
  patch = openapi_operation(),
  trace = openapi_operation(),
  parameters = list()
)

openapi_operation(
  summary = character(),
  description = character(),
  operation_id = character(),
  parameters = list(),
  request_body = openapi_request_body(),
  responses = list(),
  tags = character()
)

openapi_parameter(
  name = character(),
  location = c("path", "query", "header", "cookie"),
  description = character(),
  required = logical(),
  schema = openapi_schema(),
  content = openapi_content(),
  ...
)

openapi_header(description = character(), schema = openapi_schema())

openapi_schema(x, default = NULL, min = NULL, max = NULL, ..., required = NULL)

openapi_content(...)

openapi_request_body(
  description = character(),
  content = openapi_content(),
  required = logical()
)

openapi_response(
  description = character(),
  content = openapi_content(),
  headers = list()
)

openapi_tag(name = character(), description = character())
}
\arguments{
\item{openapi}{The OpenAPI version the spec adheres to. The helpers assume
3.0.0 so this is also the default value}

\item{info}{A list as constructed by \code{openapi_info()}}

\item{paths}{A named list. The names correspond to endpoints and the elements
are lists as constructed by \code{openapi_path()}}

\item{tags}{For \code{openapi()} a list with elements corresponding to the value
constructed by \code{openapi_tag()}. For \code{openapi_operation()} a character vector
or a list of strings}

\item{title}{A string giving the title of the API}

\item{description}{A longer description of the respective element. May use
markdown}

\item{terms_of_service}{A URL to the terms of service for the API}

\item{contact}{A list as constructed by \code{openapi_contact()}}

\item{license}{A list as constructed by \code{openapi_license()}}

\item{version}{A string giving the version of the API}

\item{name}{The name of the contact, license, parameter, or tag}

\item{url}{The URL pointing to the contact or license information}

\item{email}{An email address for the contact}

\item{summary}{A one-sentence summary of the path or operation}

\item{get, put, post, delete, options, head, patch, trace}{A list describing the
specific HTTP method when requested for the path, as constructed by
\code{openapi_operation()}}

\item{parameters}{A list of parameters that apply to the path and/or
operation. If this is given in \code{openapi_path()} it is inherited by all its
operations.}

\item{operation_id}{A unique string that identifies this operation in the API}

\item{request_body}{A list as constructed by \code{openapi_request_body()}}

\item{responses}{A named list with the name corresponding to the response
code and the elements being lists as constructed by \code{openapi_response()}}

\item{location}{Where this parameter is coming from. Either \code{"path"},
\code{"query"}, \code{"header"}, or \code{"cookie"}.}

\item{required}{For \code{openapi_parameter} a boolean indicating if this is a
required parameter (\code{"path"} parameters are always required). For
\code{openapi_schema()} a character vector naming the required properties of an
object.}

\item{schema}{A description of the data as constructed by \code{openapi_schema}}

\item{content}{A list as constructed by \code{openapi_content()}.}

\item{...}{Further named arguments to be added to the element. For
\code{openapi_content()} named elements as constructed by \code{openapi_schema()}}

\item{x}{An R object corresponding to the type of the schema. Supported types
are:
\itemize{
\item \code{integer}: Will signal \code{type: integer}
\item \code{numeric}: Will signal \code{type: number}
\item \code{character}: Will signal \code{type: string}
\item \code{factor}: Will signal \code{type: string} and \code{enum} set the factor levels
\item \code{raw}: Will signal \verb{type:string; format: binary}
\item \code{Date}: Will signal \verb{type:string; format: date}
\item \code{POSIXt}: Will signal \verb{type:string; format: date-time}
\item \code{list}: If unnamed it must be a one-length list and will signal
\code{type: array} and \code{items} set to the schema of its element. If named it
will signal \code{type: object} and \code{properties} set to the schema of each
element.
\item \code{AsIs}: Will signal a \code{type} equivalent to the value of the input (must be
a string)
}}

\item{default}{A default value for the parameter. Must be reconsilable with
the type of \code{x}}

\item{min, max}{Bounds for the value of the parameter}

\item{headers}{A named list with names corresponding to headers and elements
as constructed by \code{openapi_header()}}
}
\value{
A list
}
\description{
These helper functions aid in constructing OpenAPI compliant specifications
for your API. The return simple lists and you may thus forego these helpers
and instead construct it all manually (or import it from a json or yaml
file). The purpose of these helpers is mainly in basic input checking and for
documenting the structure. Read more about the spec at
\url{https://spec.openapis.org/oas/v3.0.0.html}
}
\examples{
# Create docs for an API with a single endpoint
doc <- openapi(
  info = openapi_info(
    title = "My awesome api",
    version = "1.0.0"
  ),
  paths = list(
    "/hello/{name}" = openapi_path(
      get = openapi_operation(
        summary = "Get a greeting",
        parameters = list(
          openapi_parameter(
            name = "name",
            location = "path",
            description = "Your name",
            schema = openapi_schema(character())
          )
        ),
        responses = list(
          "200" = openapi_response(
            description = "a kind message",
            content = openapi_content(
              "text/plain" = openapi_schema(character())
            )
          )
        )
      )
    )
  )
)

# Add it to an api
api() |>
  api_doc_add(doc)


}
