% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau_handler.R
\name{arg_spec}
\alias{arg_spec}
\alias{return_spec}
\title{Describe expected args and return values}
\usage{
arg_spec(
  type = c("character", "integer", "logical", "numeric"),
  desc = "",
  optional = grepl("\\\\?$", type)
)

return_spec(type = c("character", "integer", "logical", "numeric"), desc = "")
}
\arguments{
\item{type}{A string indicating the data type that is required for this
argument.}

\item{desc}{A human-readable description of the argument. Used to generate
documentation.}

\item{optional}{If \code{TRUE}, then this argument need not be present in a
request. Defaults to \code{TRUE} if \code{type} ends with a \code{"?"} character.}
}
\value{
A \code{tableau_arg_spec} object, which is a list containing details about
the Tableau argument expectations

A \code{tableau_return_spec} object, which is a list containing details
about the values expected to be returned to Tableau
}
\description{
\code{arg_spec()} and \code{return_spec()} are used to create arguments for
\code{\link[=tableau_handler]{tableau_handler()}}. They describe the data type of the arg or return value,
and can return a human-readable description that can be used to generate
documentation.
}
