% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_plot.R
\name{cal_plot}
\alias{cal_plot}
\title{Plot apparent and bias-corrected calibration curves}
\usage{
cal_plot(
  x,
  xlim,
  ylim,
  xlab,
  ylab,
  app_col,
  bc_col,
  app_lty,
  bc_lty,
  plotci = c("if", "yes", "no")
)
}
\arguments{
\item{x}{an object returned from \code{\link{validate}}. Original call should
have specified 'eval' argument. See \code{\link{score_binary}}.}

\item{xlim}{x limits (default = c(0, max of either curve))}

\item{ylim}{y limits (default = c(0, max of either curve))}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{app_col}{color of the apparent calibration curve (default = 'black')}

\item{bc_col}{color of the bias-corrected calibration curve (default = 'black')}

\item{app_lty}{line type of the apparent calibration curve (default = 1)}

\item{bc_lty}{line type of the bias-corrected calibration curve (default = 2)}

\item{plotci}{plot confidence intervals ('yes') or not ('no'). If 'yes' x should have confidence intervals
added by \code{\link{confint.internal_validate}}. 'if' (default) plots CIs if they are
available.}
}
\value{
plots apparent and bias-corrected curves. Silently returns a data.frame
that can be used to produce a more 'publication ready' plot. Columns are as
follows: predicted = values for the x-axis, apparent = value of apparent curve,
bias_corrected = value of bias-corrected curve. Confidence intervals are included
if available.
}
\description{
Plot apparent and bias-corrected calibration curves
}
\examples{
library(pminternal)
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ x1 + x2, data=dat, family="binomial")

# to get a plot of bias-corrected calibration we need
# to specify 'eval' argument via 'calib_args'
# this argument specifies at what points to evalulate the
# calibration curve for plotting. The example below uses
# 100 equally spaced points between the min and max
# original prediction.

p <- predict(m1, type="response")
p100 <- seq(min(p), max(p), length.out=100)

m1_iv <- validate(m1, method="cv_optimism", B=10,
                  calib_args = list(eval=p100))
# calib_ags can be used to set other calibration curve
# settings: see pmcalibration::pmcalibration

cal_plot(m1_iv)

}
