% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmultinom.R
\name{pmultinom}
\alias{pmultinom}
\title{Calculate the probability that a multnomial random vector is between,
elementwise, two other vectors.}
\usage{
pmultinom(lower = -Inf, upper = Inf, size, probs, method)
}
\arguments{
\item{lower}{Vector of lower bounds. Lower bounds are excluded}

\item{upper}{Vector of upper bounds. Upper bounds are included}

\item{size}{Number of draws}

\item{probs}{Cell probabilities}

\item{method}{Method used for computation. Only method currently implemented is "exact"}
}
\value{
The probability that a multinomial random vector is greater than all
  the lower bounds, and less than or equal all the upper bounds:

P(l1 < N1 <= u1, ..., lk < Nk <= uk)

If only the upper bounds are given, then this is the multinomial CDF:

P(N1<=u1, ..., Nk<=uk)

If only the upper bounds are given, then this is the multinomial tail probability:

P(N1>l1, ..., Nk>lk)
}
\description{
Calculate the probability that a multnomial random vector is between,
elementwise, two other vectors.
}
\details{
The calculation follows the scheme suggested in Levin (1981): begin with the
equivalent probability for a Poisson random vector, and update it by
conditioning on the sum of the vector being equal to the size parameter,
using Bayes' theorem. This requires computation of the distribution of a sum
of truncated Poisson random variables, which is accomplished using
convolution, as per Levin's suggestion for an exact calculation. Levin's
suggestion for an approximate calculation, using Edgeworth expansions, may be
added to a later version. Fast convolution is achieved using the fastest
Fourier transform in the west (Frigo, Johnson 1998).
}
\examples{
# To determine the bias of a die, Rudolph Wolf rolled it
# 20,000 times. Side 2 was the most frequently observed, and
# was observed 3631 times. What is the probability that a
# fair die would have a side observed this many times or
# more?

# Input: 
1 - pmultinom(upper=rep.int(3630, 6), size=20000,
              probs=rep.int(1/6, 6), method="exact")
# Output:
# [1] 7.379909e-08

# Therefore we conclude that the die is biased. Fougere
# (1988) attempted to account for these biases by assuming
# certain manufacturing errors. Repeating the calculation
# with the distribution Fougere derived:

# Input:
theoretical.dist <- c(.17649, .17542, .15276, .15184, .17227, .17122)
1 - pmultinom(upper=rep.int(3630, 6), size=20000,
              probs=theoretical.dist, method="exact")
# Output:
# [1] 0.043362

# Therefore we conclude that the die still seems more biased
# than Fougere's model can explain.

}
\references{
Fougere, P. F. (1988). Maximum entropy calculations on a discrete probability space. In Maximum-Entropy and Bayesian Methods in Science and Engineering (pp. 205-234). Springer, Dordrecht. doi:10.1007/978-94-009-3049-0_10

  Frigo, Matteo, and Steven G. Johnson. (2005). The design and implementation of FFTW3. Proceedings of the IEEE, 93(2), 216-231. doi:10.1109/JPROC.2004.840301

  Levin, Bruce. (1981). "A Representation for Multinomial Cumulative Distribution Functions". Annals of Statistics 9 (5): 1123–6. doi:10.1214/aos/1176345593
}
\seealso{
\code{\link{invert.pmultinom}}
}
