% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_split_trade_house_addresses}
\alias{general_split_trade_house_addresses}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_split_trade_house_addresses(directory, regex, verbose)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{addresses}.}

\item{regex}{Regex to use for the task provided as a character string.}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{addresses.trade} and \code{address.house}. Trade
addresses are separated from house address for entries for which a house
address is provided along trade address(es).
}
\description{
Attempts to separate house address from trade address(es) in the Scottish
post office general directory data.frame provided for entries for which a
house address is provided along trade address(es).
}
