#' Danish Lower Chamber Electoral Results
#'
#' A dataset containing data on electoral results for the Danish lower chamber by party and by electoral district from 1906 to 2019 (except the 1915 election). The variables include country name, year and month of election, electoral district name and code, party name and code, and party vote share.
#'
#' @format ## `denmark`
#' A data frame with rows and columns:
#' \describe{
#'   \item{ctr_n}{Country name}
#'   \item{yr}{Year of election}
#'   \item{mn}{Month of election}
#'   \item{cst_n}{Name of electoral district}
#'   \item{cst}{Code of electoral district}
#'   \item{pty_n}{Party name}
#'   \item{pty}{Party code}
#'   \item{pvs1}{Party vote share}
#' }
#'
#' @details
#'
#' This dataset is part of the Constituency-Level Elections Archive (CLEA) project,
#' a repository that provides detailed election results at the constituency level
#' for lower chamber and upper chamber legislative elections from around the world.
#'
#' @source <https://electiondataarchive.org/>
#'
#' @return
#' This dataset is part of the Constituency-Level Elections Archive (CLEA). Danish Lower Chamber Electoral Results
#'
#' @references
#'
#' Kollman, K., Hicken, A., Caramani, D., Backer, D., & Lublin, D. (2019). Constituency-level elections archive [data file and codebook]. Ann Arbor, MI: Center for Political Studies, University of Michigan [producer and distributor]. Retrieved from http://www.electiondataarchive.org.
#'
"denmark"
