% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desp_lh.R
\name{lh}
\alias{lh}
\title{Loosemore–Hanby Index}
\usage{
lh(x, y)
}
\arguments{
\item{x}{(\code{numeric}). Numeric vector with the vote share of parties}

\item{y}{(\code{numeric}). Numeric vector with the seat share of parties}
}
\value{
If the input is a proportion the result is between 0 and 1.
  But if the input is a percentage it is between 0 and 100.
  In both cases the higher the value, the more disproportional the electoral system is.
}
\description{
`lh()` calculates the electoral disproportionality between votes and
seats as proposed by Loosemore and Hanby (1971).
}
\examples{

votes <- c(0.2, 0.2, 0.6)
seats <- c(0.18, 0.17, 0.65)
lh(votes, seats)

}
\references{
Loosemore, J., & Hanby, V. (1971). The Theoretical Limits of Maximum Distortion: Some Analytic Expressions for Electoral Systems. British Journal of Political Science, 1(4), 467-477. doi:10.1017/S000712340000925X
}
