% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rice.R
\name{rice}
\alias{rice}
\title{Rice Index}
\usage{
rice(x)
}
\arguments{
\item{x}{(\code{factor}). A factor vector with two levels (i.e., Yay or Nay)}
}
\value{
The index ranges from 0 to 1, where 1 is complete cohesion and 0 the formation of two equally sized subgroups within the party.
}
\description{
`rice` proposed by Rice (1925) is used to measure party cohesion in parliamentary votes by considering two voting blocks (usually government and opposition)
}
\examples{

voting <- as.factor(c(rep("Yes", 90), rep("No", 10)))
rice(voting)

}
\references{
Rice, S. A. (1925). The Behavior of Legislative Groups: A Method of Measurement. Political Science Quarterly, 40(1), 60–72. https://doi.org/10.2307/2142407
}
