% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_gcd.R
\name{GCD}
\alias{GCD}
\alias{GCD,polyMatrix-method}
\title{GCD for polynomial matrices}
\usage{
GCD(...)

\S4method{GCD}{polyMatrix}(...)
}
\arguments{
\item{...}{a list of polynomial objects}
}
\description{
The greatest common divisor of polynomials or polynomial matrices.
}
\section{Methods (by class)}{
\itemize{
\item \code{polyMatrix}: the greatest common divisor of all elements of the polynomial matrix
}}

\examples{

# GCD of polynomial matrix

GCD(parse.polyMatrix(
 "  1 - x, 1 - x^2, 1 + 2*x + x^2",
 "x - x^2,   1 + x, 1 - 2*x + x^2"
))  ## 1

}
\seealso{
polynomial implementation \code{\link[polynom:gcd]{polynom::GCD()}} and \code{\link[=LCM]{LCM()}}
}
