% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/utils.R
\name{dist_polysph}
\alias{dist_polysph}
\alias{dist_polysph_cross}
\alias{dist_polysph_matrix}
\title{Polyspherical distance}
\usage{
dist_polysph(x, y, ind_dj, norm_x = FALSE, norm_y = FALSE, std = TRUE)

dist_polysph_cross(x, y, ind_dj, norm_x = FALSE, norm_y = FALSE,
  std = TRUE)

dist_polysph_matrix(x, ind_dj, norm_x = FALSE, norm_y = FALSE,
  std = TRUE)
}
\arguments{
\item{x}{a matrix of size \code{c(n, sum(d) + r)}.}

\item{y}{either a matrix of size \code{c(m, sum(d) + r)} or a vector of
length \code{sum(d) + r}.}

\item{ind_dj}{\code{0}-based index separating the blocks of spheres that
is computed with \code{\link{comp_ind_dj}}.}

\item{norm_x, norm_y}{ensure a normalization of the data? Default to
\code{FALSE}.}

\item{std}{standardize distance to \eqn{[0,1]}? Uses that the maximum
distance is \eqn{\sqrt{r}\pi}. Defaults to \code{TRUE}.}
}
\value{
\itemize{
\item{\code{dist_polysph}: a vector of size \code{n} with the distances
between \code{x} and \code{y}.}
\item{\code{dist_polysph_matrix}: a matrix of size \code{c(n, n)} with the
pairwise distances of \code{x}.}
\item{\code{dist_polysph_cross}: a matrix of distances of size
\code{c(n, m)} with the cross distances between \code{x} and \code{y}.}
}
}
\description{
Computation of the distance between points \eqn{\boldsymbol{x}}
and \eqn{\boldsymbol{y}} on the polysphere
\eqn{\mathcal{S}^{d_1} \times \cdots \times \mathcal{S}^{d_r}}:
\deqn{\sqrt{\sum_{j=1}^r
d_{\mathcal{S}^{d_j}}(\boldsymbol{x}_j, \boldsymbol{y}_j)^2},}
where \eqn{d_{\mathcal{S}^{d_j}}(\boldsymbol{x}_j, \boldsymbol{y}_j)=
\cos^{-1}(\boldsymbol{x}_j' \boldsymbol{y}_j)}.
}
\examples{
# Example on S^2 x S^3 x S^1
d <- c(2, 3, 1)
ind_dj <- comp_ind_dj(d)
n <- 3
x <- r_unif_polysph(n = n, d = d)
y <- r_unif_polysph(n = n, d = d)

# Distances of x to y
dist_polysph(x = x, y = y, ind_dj = ind_dj, std = FALSE)
dist_polysph(x = x, y = y[1, , drop = FALSE], ind_dj = ind_dj, std = FALSE)

# Pairwise distance matrix of x
dist_polysph_matrix(x = x, ind_dj = ind_dj, std = FALSE)

# Cross distances between x and y
dist_polysph_cross(x = x, y = y, ind_dj = ind_dj, std = FALSE)
}
