% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projection}
\alias{projection}
\title{Defining a Belief Space Projection}
\usage{
projection(x = NULL, model)
}
\arguments{
\item{x}{specification of the projection (see Details section).}

\item{model}{a \link{POMDP}.}
}
\value{
a canonical description of the projection.
}
\description{
High dimensional belief spaces can be projected to lower dimension. This is useful for visualization and
to analyze the belief space and value functions. This definition is used by functions like \code{\link[=plot_belief_space]{plot_belief_space()}},
\code{\link[=plot_value_function]{plot_value_function()}}, and \code{\link[=sample_belief_space]{sample_belief_space()}}.
}
\details{
The belief space is $n-1$ dimensional, were $n$ is the number of states. Note: it is n-1 dimensional since the probabilities
need to add up to 1. A projection fixes the belief value for a set of states. For example, for a 4-state POMDP
(s1, s2, s3, s4), we can project the belief space on s1 and s2 by holding s3 and s4 constant
which is represented by the vector \code{c(s1 = NA, s2 = NA, s3 = 0, s4 = .1)}. We use \code{NA} to represent that the values are not
fixed and the value that the other dimensions are held constant.

We provide several ways to specify a projection:
\itemize{
\item A vector with values for all dimensions. \code{NA}s are used for the dimension projected on. This is the canonical form
used in this package. Example: \code{c(NA, NA, 0, .1)}
\item A named vector with just the dimensions held constant. Example: \code{c(s3 = 0, s4 = .1)}
\item A vector of state names to project on. All other dimensions are held constant at 0. Example: \code{c("s1", "s2")}
\item A vector with indices of the states to project on. All other dimensions are held constant at 0. Example: \code{c(1, 2)}
}
}
\examples{
model <- POMDP(
 states = 4,
 actions = 2,
 observations = 2,
 transition_prob = list("identity","identity"),
 observation_prob = list("uniform","uniform"),
 reward = rbind(R_(value = 1))
)

projection(NULL, model = model)
projection(1:2, model = model)
projection(c("s2", "s3"), model = model)
projection(c(1,4), model = model)
projection(c(s2 = .4, s3 = .2), model = model)
projection(c(s1 = .1, s2 = NA, s3 = NA, s4 = .3), model = model)
}
\seealso{
Other policy: 
\code{\link{estimate_belief_for_nodes}()},
\code{\link{optimal_action}()},
\code{\link{plot_belief_space}()},
\code{\link{plot_policy_graph}()},
\code{\link{policy}()},
\code{\link{policy_graph}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{value_function}()}

Other POMDP: 
\code{\link{MDP2POMDP}},
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{POMDP}
\concept{policy}
