% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupClustering.R
\name{ExtractCI}
\alias{ExtractCI}
\title{Calculates the Wald or a parametric bootstrap confidence intervals for GLMs and GLMMs}
\usage{
ExtractCI (Model, EffectIndices = NULL, EffectLabels = NULL,
         ParBootstrap = FALSE, Nboots = 999, digits = 4, coverage = 0.95,
         UpperBound = Inf, SignificanceLevel =  1-coverage,
         EffectsMatrix = NULL, Scale = 1.0, Location = 0.0,
         isBinomialModel = FALSE, BackTransform = TRUE)
}
\arguments{
\item{Model}{a model of class lm, glm, glmerMod, lme or gls.}

\item{EffectIndices}{a vector containing the indices of the effects to
be analysed (default = NULL, indicating that all the levels are used).}

\item{EffectLabels}{a character vector with the labels of the effects
(default = NULL, which implies that the corresponding labels of the model
coefficient are used).}

\item{ParBootstrap}{logic flag indicating whether the confidence intervals
should be calculated with parametric bootstrap (default is false, i.e.
the Wald confidence interval is used).}

\item{Nboots}{number of bootstrap samples used for the confidence interval.
(default = 999).}

\item{digits}{number of digits used when reporting the results}

\item{coverage}{the coverage of the confidence intervals (default = 0.95)}

\item{UpperBound}{an upper bound to the confidence intervals (default = Inf)}

\item{SignificanceLevel}{the significance level of the pairwise comparisons
(default = 0.05).}

\item{EffectsMatrix}{matrix defining contrasts to be compared (bypasses
the EffectIndices, default is NULL, meaning that standard inference is performed).}

\item{Scale}{a scaling factor multiplying the output table (default = 1,
i.e., no scaling is used).}

\item{Location}{a location term added to the output table (default = 0,
i.e., no location shift is performed).}

\item{isBinomialModel}{a logical flag indicating whther the model is a
binomial model different than the Bernoulli (default = FALSE, i.e. not a binomial model).}

\item{BackTransform}{should the parameters and CIs be back transformed by
applying the inverse link function (default = TRUE)}
}
\value{
an object of (S3) class "PostHoc".

a matrix with three columns containing the effects, the lower
 bound and the upper bound of the confidence intervals for the effects.
}
\description{
posthoc is used to group or cluster the effects of liner,
 generalised linear and generalised linear mixed models according to significance of pairwise tests comparing the levels of the effects.
}
\details{
Two possible methos for obtaining confidence intervals are
 available: Wald confidence intervals and parametric bootstrap confidence intervals.
}
\examples{
MM <- glm(Y ~ Treatment+0,  data=DeIdentifiedExample)
ExtractCI (MM)
}
\author{
Rodrigo Labouriau
}
\keyword{pairwise-comparisons}
\keyword{post-hoc}
