% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.refdist.poth.R
\name{plot.refdist}
\alias{plot.refdist}
\title{Plot reference distribution for given network}
\usage{
\method{plot}{refdist}(x, observed = TRUE, probability = FALSE, ...)
}
\arguments{
\item{x}{R object of class \code{refdist}.}

\item{observed}{A logical indicating whether a line with the observed POTH
should be drawn in the plot.}

\item{probability}{A logical indicating whether the probability of a POTH
greater than the observed POTH should be printed in the legend. This
argument is ignored if \code{observed = FALSE}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Plot a histogram of simulated reference distribution for POTH
}
\details{
Plots a histogram of the simulated POTH values from the reference
distribution. (Wigle et al., 2024).
}
\examples{
\donttest{
library("netmeta")
data(smokingcessation)
p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(p1, random = FALSE)

# Reference distribution
dist1 <- refdist(net1, pooled = "common", nsim = 2)
plot(dist1, observed = FALSE)

data(Senn2013)
net2 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
                data = Senn2013, sm = "MD", random = FALSE)

# Reference distribution
dist2 <- refdist(net2, pooled = "common", nsim = 25)
plot(dist2, probability = TRUE)
}
}
\references{
Wigle A, Béliveau A, Salanti G, Rücker G, Schwarzer G, Mavridis D,
Nikolakopoulou A (2024):
Precision of treatment hierarchy: A metric for quantifying uncertainty in
treatment hierarchies in network meta-analysis.
Preprint on arXiv, \doi{10.48550/arXiv.2501.11596}
}
\author{
Augustine Wigle \email{amhwigle@uwaterloo.ca},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
