% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerCompute.R
\name{getPowerMultTSS}
\alias{getPowerMultTSS}
\title{Function for computing the power given the region of acceptance}
\usage{
getPowerMultTSS(accept_regions, alt_data)
}
\arguments{
\item{accept_regions}{Numeric matrix (one row per TSS) with two or four
columns: The first two columns contain the interval limits of the region
of acceptance, i.e., we reject the null hypothesis for values strictly
outside of this interval. The third and fourth columns contain the
probabilities to reject the null hypothesis if values equal the lower or
upper bound, respectively. If the last two columns are missing they are
interpreted as zeroes. See return value of \code{getAccRegion()}.}

\item{alt_data}{Numeric matrix  (one row per TSS) with values under the
alternative model.
If there is only one TSS, then it can be a simple vector of values instead
(returns a single unnamed value).}
}
\value{
\code{getPowerMultTSS} A vector containing the power regarding the
given TSS (retains row names of \code{accept_regions}).
}
\description{
\code{getPowerMultTSS} - Computes the power of one or multiple TSS by
calculating the proportion of values outside the region of acceptance for
a single alternative model.
}
\examples{
# Example with small data (with/without third and fourth column):
getPowerMultTSS(accept_regions = c(2,3, 0,0), alt_data = c(1,2,4,5))
getPowerMultTSS(accept_regions = c(2,3, 0.5,1), alt_data = c(1,2,4,5))
# Example with multiple rows/TSS:
getPowerMultTSS(accept_regions = matrix(c(2,3,0,0,
                                          20,30,0.5,0.5),
                                   nrow = 2, byrow = TRUE,
                                   dimnames = list(c("TSS1", "TSS2"), NULL)),
                alt_data = matrix(c(  1,2,3,4,
                                    10,20,30,40),
                                  nrow = 2, byrow = TRUE,
                                  dimnames = list(c("TSS1", "TSS2"), NULL)))
# Example with generated TSS data:
getPowerMultTSS(accept_regions = getAccRegion(tss = c("Colless","SNI"),
                                              n = 6L),
                alt_data = getTSSdata(tss = c("Colless", "SNI"), n = 6L,
                                      Ntrees = 20L, tm = list("aldous", -1)))
}
