% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmDensity.R
\name{genDensityTree}
\alias{genDensityTree}
\title{Generation of rooted binary trees under the density model}
\usage{
genDensityTree(n, BIRTHRATE = 1, EQUILIB, TRIES = 5, TIMEperTRY = 0.01)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.\cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format,
the number of leaves must be at least 2 since there must be at
least one edge.}

\item{BIRTHRATE}{Positive numeric value (default = 1) which specifies the
rate at which the speciation events occur.}

\item{EQUILIB}{Integer value that specifies the equilibrium number.}

\item{TRIES}{Integer value (default = 5) that specifies
the number of attempts to generate a tree with \code{n} leaves.}

\item{TIMEperTRY}{Numeric value (default = 0.01) that specifies the maximum
amount of time (in seconds) invested per try.}
}
\value{
\code{genDensityTree} A single tree of class \code{phylo} is
returned.
}
\description{
\code{genDensityTree} - Generates a rooted binary tree in \code{phylo}
format with the given number of \code{n} leaves under the
density-dependent model.
In the density-dependent tree generation process all species have the same
speciation \code{BIRTHRATE}, but the extinction rates depend on the
number of species (it increases linearly with the number of co-existing
lineages until an equilibrium number is reached at which speciation and
extinction rates are equal).
Extinct species are removed from the tree, i.e., the generated tree contains
only species living at the present.
}
\examples{
genDensityTree(n = 5, EQUILIB = 6)
}
\references{
\itemize{
\item P. H. Harvey, R. M. May, and S. Nee. Phylogenies without fossils.
Evolution, 48(3):523–529, 1994.
}
}
