% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerHE.R
\name{formatHE}
\alias{formatHE}
\title{Format powerHE Results}
\usage{
formatHE(result)
}
\arguments{
\item{result}{A list (return object of powerHE).}
}
\value{
A data frame containing the information from parameter 'result' with columns "Label" and "Value".
}
\description{
This function formats the results outputted from the powerHE function. See below (pdf) or use ?powerHE (in R) to view its documentation.
}
\examples{
# Example TTE endpoint with formatting:

endpoints_input <- list(
  list(type = "TTE",
       hr = 0.8,
       er.b = 0.25,
       s = 12,
       tte.winning.direction = "GT")
)
results <- powerHE(endpoints_input,
               sample.size = 100,
               alpha = 0.05,
               rratio = 0.5,
               output = "ALL")
formatHE(results)
}
\keyword{formatHE}
