% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_unordered.R
\name{equal.unordered}
\alias{equal.unordered}
\title{Subsidiary PowerLATE Function}
\usage{
equal.unordered(
  power = NULL,
  sig.level = NULL,
  pi = NULL,
  kappa = NULL,
  N = NULL
)
}
\arguments{
\item{power}{power of test (1 minus Type II error probability)}

\item{sig.level}{significance level (Type I error probability).}

\item{pi}{compliance rate. Equivalently, average causal effect of Z on D.}

\item{kappa}{effect size}

\item{N}{total number of observations}
}
\value{
A vector of values for one in \{kappa, N, power\} that is not supplied by the user.
}
\description{
Subsidiary function to perform power calculation under equal assignment probability and without ordered mean assumption.
}
\note{
This function is called internally and thus should not be used directly.
}
\references{
Bansak, K. (2020). A Generalized Approach to Power Analysis for Local Average Treatment Effects. Statistical Science, 35(2), 254-271.
}
\seealso{
\code{\link{equal.ordered}}, \code{\link{unequal.ordered}}, \code{\link{unequal.unordered}}.
}
\author{
Kirk Bansak and Eddie Yang
}
